/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import com.atlan.exception.AtlanException;
import com.atlan.exception.LogicException;
import com.atlan.model.core.Entity;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.SearchParameters;
import com.atlan.net.ApiResource;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import lombok.Generated;

public class IndexSearchResponse
extends ApiResource {
    private static final long serialVersionUID = 2L;
    String queryType;
    SearchParameters searchParameters;
    List<Entity> entities;
    Long approximateCount;

    @JsonIgnore
    public IndexSearchResponse getNextPage() throws AtlanException {
        IndexSearchDSL dsl;
        try {
            dsl = (IndexSearchDSL)Serde.mapper.readValue(this.searchParameters.getQuery(), IndexSearchDSL.class);
        }
        catch (JsonProcessingException e) {
            throw new LogicException("Unable to parse original query from the response.", "ATLAN-JAVA-CLIENT-500-040", 500, e);
        }
        int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
        int page = dsl.getSize() == null ? 10 : dsl.getSize();
        dsl.setFrom(from + page);
        Object next = IndexSearchRequest.builder().dsl(dsl);
        if (this.searchParameters.getAttributes() != null) {
            next = ((IndexSearchRequest.IndexSearchRequestBuilder)next).attributes(this.searchParameters.getAttributes());
        }
        if (this.searchParameters.getRelationAttributes() != null) {
            next = ((IndexSearchRequest.IndexSearchRequestBuilder)next).relationAttributes(this.searchParameters.getRelationAttributes());
        }
        return ((IndexSearchRequest)((IndexSearchRequest.IndexSearchRequestBuilder)next).build()).search();
    }

    @Generated
    public IndexSearchResponse() {
    }

    @Generated
    public String getQueryType() {
        return this.queryType;
    }

    @Generated
    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    @Generated
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Generated
    public Long getApproximateCount() {
        return this.approximateCount;
    }

    @Generated
    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    @Generated
    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    @Generated
    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    @Generated
    public void setApproximateCount(Long approximateCount) {
        this.approximateCount = approximateCount;
    }

    @Override
    @Generated
    public String toString() {
        return "IndexSearchResponse(queryType=" + this.getQueryType() + ", searchParameters=" + this.getSearchParameters() + ", entities=" + this.getEntities() + ", approximateCount=" + this.getApproximateCount() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexSearchResponse)) {
            return false;
        }
        IndexSearchResponse other = (IndexSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$approximateCount = this.getApproximateCount();
        Long other$approximateCount = other.getApproximateCount();
        if (this$approximateCount == null ? other$approximateCount != null : !((Object)this$approximateCount).equals(other$approximateCount)) {
            return false;
        }
        String this$queryType = this.getQueryType();
        String other$queryType = other.getQueryType();
        if (this$queryType == null ? other$queryType != null : !this$queryType.equals(other$queryType)) {
            return false;
        }
        SearchParameters this$searchParameters = this.getSearchParameters();
        SearchParameters other$searchParameters = other.getSearchParameters();
        if (this$searchParameters == null ? other$searchParameters != null : !((Object)this$searchParameters).equals(other$searchParameters)) {
            return false;
        }
        List<Entity> this$entities = this.getEntities();
        List<Entity> other$entities = other.getEntities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexSearchResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $approximateCount = this.getApproximateCount();
        result = result * 59 + ($approximateCount == null ? 43 : ((Object)$approximateCount).hashCode());
        String $queryType = this.getQueryType();
        result = result * 59 + ($queryType == null ? 43 : $queryType.hashCode());
        SearchParameters $searchParameters = this.getSearchParameters();
        result = result * 59 + ($searchParameters == null ? 43 : ((Object)$searchParameters).hashCode());
        List<Entity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }
}

