/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.typedefs;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanCustomAttributeCardinality;
import com.atlan.model.enums.AtlanCustomAttributePrimitiveType;
import com.atlan.model.typedefs.AttributeDefOptions;
import com.atlan.model.typedefs.Constraint;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(builder=AttributeDefBuilderImpl.class)
public class AttributeDef
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String name;
    String displayName;
    String description;
    String typeName;
    String defaultValue;
    Boolean isOptional;
    AtlanCustomAttributeCardinality cardinality;
    Long valuesMinCount;
    Long valuesMaxCount;
    Boolean isUnique;
    Boolean isIndexable;
    Boolean includeInNotification;
    final Boolean skipScrubbing;
    final Long searchWeight;
    final String indexType;
    AttributeDefOptions options;
    Boolean isNew;
    final List<Constraint> constraints;
    final Map<String, String> indexTypeESConfig;
    final Map<String, Map<String, String>> indexTypeESFields;
    final Map<String, List<String>> autoUpdateAttributes;

    public static AttributeDef of(String displayName, AtlanCustomAttributePrimitiveType type, String optionsName, boolean multiValued) {
        String baseType;
        Object builder = ((AttributeDefBuilder)AttributeDef.builder().name(displayName)).displayName(displayName);
        switch (type) {
            case OPTIONS: {
                baseType = optionsName;
                break;
            }
            case USERS: 
            case GROUPS: 
            case URL: 
            case SQL: {
                baseType = AtlanCustomAttributePrimitiveType.STRING.getValue();
                break;
            }
            default: {
                baseType = type.getValue();
            }
        }
        builder = multiValued ? ((AttributeDefBuilder)((AttributeDefBuilder)builder).typeName("array<" + baseType + ">")).options((AttributeDefOptions)((AttributeDefOptions.AttributeDefOptionsBuilder)AttributeDefOptions.of(type, optionsName).toBuilder().multiValueSelect(true)).build()) : ((AttributeDefBuilder)((AttributeDefBuilder)builder).typeName(baseType)).options(AttributeDefOptions.of(type, optionsName));
        return ((AttributeDefBuilder)builder).build();
    }

    @Generated
    private static Boolean $default$isOptional() {
        return true;
    }

    @Generated
    private static AtlanCustomAttributeCardinality $default$cardinality() {
        return AtlanCustomAttributeCardinality.SINGLE;
    }

    @Generated
    private static Long $default$valuesMinCount() {
        return 0L;
    }

    @Generated
    private static Long $default$valuesMaxCount() {
        return 1L;
    }

    @Generated
    private static Boolean $default$isUnique() {
        return false;
    }

    @Generated
    private static Boolean $default$isIndexable() {
        return true;
    }

    @Generated
    private static Boolean $default$includeInNotification() {
        return false;
    }

    @Generated
    private static Boolean $default$isNew() {
        return true;
    }

    @Generated
    protected AttributeDef(AttributeDefBuilder<?, ?> b) {
        super(b);
        this.name = b.name;
        this.displayName = b.displayName;
        this.description = b.description;
        this.typeName = b.typeName;
        this.defaultValue = b.defaultValue;
        this.isOptional = b.isOptional$set ? b.isOptional$value : AttributeDef.$default$isOptional();
        this.cardinality = b.cardinality$set ? b.cardinality$value : AttributeDef.$default$cardinality();
        this.valuesMinCount = b.valuesMinCount$set ? b.valuesMinCount$value : AttributeDef.$default$valuesMinCount();
        this.valuesMaxCount = b.valuesMaxCount$set ? b.valuesMaxCount$value : AttributeDef.$default$valuesMaxCount();
        this.isUnique = b.isUnique$set ? b.isUnique$value : AttributeDef.$default$isUnique();
        this.isIndexable = b.isIndexable$set ? b.isIndexable$value : AttributeDef.$default$isIndexable();
        this.includeInNotification = b.includeInNotification$set ? b.includeInNotification$value : AttributeDef.$default$includeInNotification();
        this.skipScrubbing = b.skipScrubbing;
        this.searchWeight = b.searchWeight;
        this.indexType = b.indexType;
        this.options = b.options;
        this.isNew = b.isNew$set ? b.isNew$value : AttributeDef.$default$isNew();
        this.constraints = b.constraints;
        this.indexTypeESConfig = b.indexTypeESConfig;
        this.indexTypeESFields = b.indexTypeESFields;
        this.autoUpdateAttributes = b.autoUpdateAttributes;
    }

    @Generated
    public static AttributeDefBuilder<?, ?> builder() {
        return new AttributeDefBuilderImpl();
    }

    @Generated
    public AttributeDefBuilder<?, ?> toBuilder() {
        return new AttributeDefBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Boolean getIsOptional() {
        return this.isOptional;
    }

    @Generated
    public AtlanCustomAttributeCardinality getCardinality() {
        return this.cardinality;
    }

    @Generated
    public Long getValuesMinCount() {
        return this.valuesMinCount;
    }

    @Generated
    public Long getValuesMaxCount() {
        return this.valuesMaxCount;
    }

    @Generated
    public Boolean getIsUnique() {
        return this.isUnique;
    }

    @Generated
    public Boolean getIsIndexable() {
        return this.isIndexable;
    }

    @Generated
    public Boolean getIncludeInNotification() {
        return this.includeInNotification;
    }

    @Generated
    public Boolean getSkipScrubbing() {
        return this.skipScrubbing;
    }

    @Generated
    public Long getSearchWeight() {
        return this.searchWeight;
    }

    @Generated
    public String getIndexType() {
        return this.indexType;
    }

    @Generated
    public AttributeDefOptions getOptions() {
        return this.options;
    }

    @Generated
    public Boolean getIsNew() {
        return this.isNew;
    }

    @Generated
    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    @Generated
    public Map<String, String> getIndexTypeESConfig() {
        return this.indexTypeESConfig;
    }

    @Generated
    public Map<String, Map<String, String>> getIndexTypeESFields() {
        return this.indexTypeESFields;
    }

    @Generated
    public Map<String, List<String>> getAutoUpdateAttributes() {
        return this.autoUpdateAttributes;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setIsOptional(Boolean isOptional) {
        this.isOptional = isOptional;
    }

    @Generated
    public void setCardinality(AtlanCustomAttributeCardinality cardinality) {
        this.cardinality = cardinality;
    }

    @Generated
    public void setValuesMinCount(Long valuesMinCount) {
        this.valuesMinCount = valuesMinCount;
    }

    @Generated
    public void setValuesMaxCount(Long valuesMaxCount) {
        this.valuesMaxCount = valuesMaxCount;
    }

    @Generated
    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    @Generated
    public void setIsIndexable(Boolean isIndexable) {
        this.isIndexable = isIndexable;
    }

    @Generated
    public void setIncludeInNotification(Boolean includeInNotification) {
        this.includeInNotification = includeInNotification;
    }

    @Generated
    public void setOptions(AttributeDefOptions options) {
        this.options = options;
    }

    @Generated
    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeDef)) {
            return false;
        }
        AttributeDef other = (AttributeDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isOptional = this.getIsOptional();
        Boolean other$isOptional = other.getIsOptional();
        if (this$isOptional == null ? other$isOptional != null : !((Object)this$isOptional).equals(other$isOptional)) {
            return false;
        }
        Long this$valuesMinCount = this.getValuesMinCount();
        Long other$valuesMinCount = other.getValuesMinCount();
        if (this$valuesMinCount == null ? other$valuesMinCount != null : !((Object)this$valuesMinCount).equals(other$valuesMinCount)) {
            return false;
        }
        Long this$valuesMaxCount = this.getValuesMaxCount();
        Long other$valuesMaxCount = other.getValuesMaxCount();
        if (this$valuesMaxCount == null ? other$valuesMaxCount != null : !((Object)this$valuesMaxCount).equals(other$valuesMaxCount)) {
            return false;
        }
        Boolean this$isUnique = this.getIsUnique();
        Boolean other$isUnique = other.getIsUnique();
        if (this$isUnique == null ? other$isUnique != null : !((Object)this$isUnique).equals(other$isUnique)) {
            return false;
        }
        Boolean this$isIndexable = this.getIsIndexable();
        Boolean other$isIndexable = other.getIsIndexable();
        if (this$isIndexable == null ? other$isIndexable != null : !((Object)this$isIndexable).equals(other$isIndexable)) {
            return false;
        }
        Boolean this$includeInNotification = this.getIncludeInNotification();
        Boolean other$includeInNotification = other.getIncludeInNotification();
        if (this$includeInNotification == null ? other$includeInNotification != null : !((Object)this$includeInNotification).equals(other$includeInNotification)) {
            return false;
        }
        Boolean this$skipScrubbing = this.getSkipScrubbing();
        Boolean other$skipScrubbing = other.getSkipScrubbing();
        if (this$skipScrubbing == null ? other$skipScrubbing != null : !((Object)this$skipScrubbing).equals(other$skipScrubbing)) {
            return false;
        }
        Long this$searchWeight = this.getSearchWeight();
        Long other$searchWeight = other.getSearchWeight();
        if (this$searchWeight == null ? other$searchWeight != null : !((Object)this$searchWeight).equals(other$searchWeight)) {
            return false;
        }
        Boolean this$isNew = this.getIsNew();
        Boolean other$isNew = other.getIsNew();
        if (this$isNew == null ? other$isNew != null : !((Object)this$isNew).equals(other$isNew)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        AtlanCustomAttributeCardinality this$cardinality = this.getCardinality();
        AtlanCustomAttributeCardinality other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality)) {
            return false;
        }
        String this$indexType = this.getIndexType();
        String other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) {
            return false;
        }
        AttributeDefOptions this$options = this.getOptions();
        AttributeDefOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        List<Constraint> this$constraints = this.getConstraints();
        List<Constraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        Map<String, String> this$indexTypeESConfig = this.getIndexTypeESConfig();
        Map<String, String> other$indexTypeESConfig = other.getIndexTypeESConfig();
        if (this$indexTypeESConfig == null ? other$indexTypeESConfig != null : !((Object)this$indexTypeESConfig).equals(other$indexTypeESConfig)) {
            return false;
        }
        Map<String, Map<String, String>> this$indexTypeESFields = this.getIndexTypeESFields();
        Map<String, Map<String, String>> other$indexTypeESFields = other.getIndexTypeESFields();
        if (this$indexTypeESFields == null ? other$indexTypeESFields != null : !((Object)this$indexTypeESFields).equals(other$indexTypeESFields)) {
            return false;
        }
        Map<String, List<String>> this$autoUpdateAttributes = this.getAutoUpdateAttributes();
        Map<String, List<String>> other$autoUpdateAttributes = other.getAutoUpdateAttributes();
        return !(this$autoUpdateAttributes == null ? other$autoUpdateAttributes != null : !((Object)this$autoUpdateAttributes).equals(other$autoUpdateAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeDef;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isOptional = this.getIsOptional();
        result = result * 59 + ($isOptional == null ? 43 : ((Object)$isOptional).hashCode());
        Long $valuesMinCount = this.getValuesMinCount();
        result = result * 59 + ($valuesMinCount == null ? 43 : ((Object)$valuesMinCount).hashCode());
        Long $valuesMaxCount = this.getValuesMaxCount();
        result = result * 59 + ($valuesMaxCount == null ? 43 : ((Object)$valuesMaxCount).hashCode());
        Boolean $isUnique = this.getIsUnique();
        result = result * 59 + ($isUnique == null ? 43 : ((Object)$isUnique).hashCode());
        Boolean $isIndexable = this.getIsIndexable();
        result = result * 59 + ($isIndexable == null ? 43 : ((Object)$isIndexable).hashCode());
        Boolean $includeInNotification = this.getIncludeInNotification();
        result = result * 59 + ($includeInNotification == null ? 43 : ((Object)$includeInNotification).hashCode());
        Boolean $skipScrubbing = this.getSkipScrubbing();
        result = result * 59 + ($skipScrubbing == null ? 43 : ((Object)$skipScrubbing).hashCode());
        Long $searchWeight = this.getSearchWeight();
        result = result * 59 + ($searchWeight == null ? 43 : ((Object)$searchWeight).hashCode());
        Boolean $isNew = this.getIsNew();
        result = result * 59 + ($isNew == null ? 43 : ((Object)$isNew).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        AtlanCustomAttributeCardinality $cardinality = this.getCardinality();
        result = result * 59 + ($cardinality == null ? 43 : $cardinality.hashCode());
        String $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
        AttributeDefOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        List<Constraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        Map<String, String> $indexTypeESConfig = this.getIndexTypeESConfig();
        result = result * 59 + ($indexTypeESConfig == null ? 43 : ((Object)$indexTypeESConfig).hashCode());
        Map<String, Map<String, String>> $indexTypeESFields = this.getIndexTypeESFields();
        result = result * 59 + ($indexTypeESFields == null ? 43 : ((Object)$indexTypeESFields).hashCode());
        Map<String, List<String>> $autoUpdateAttributes = this.getAutoUpdateAttributes();
        result = result * 59 + ($autoUpdateAttributes == null ? 43 : ((Object)$autoUpdateAttributes).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AttributeDefBuilderImpl
    extends AttributeDefBuilder<AttributeDef, AttributeDefBuilderImpl> {
        @Generated
        private AttributeDefBuilderImpl() {
        }

        @Override
        @Generated
        protected AttributeDefBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AttributeDef build() {
            return new AttributeDef(this);
        }
    }

    @Generated
    public static abstract class AttributeDefBuilder<C extends AttributeDef, B extends AttributeDefBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String name;
        @Generated
        private String displayName;
        @Generated
        private String description;
        @Generated
        private String typeName;
        @Generated
        private String defaultValue;
        @Generated
        private boolean isOptional$set;
        @Generated
        private Boolean isOptional$value;
        @Generated
        private boolean cardinality$set;
        @Generated
        private AtlanCustomAttributeCardinality cardinality$value;
        @Generated
        private boolean valuesMinCount$set;
        @Generated
        private Long valuesMinCount$value;
        @Generated
        private boolean valuesMaxCount$set;
        @Generated
        private Long valuesMaxCount$value;
        @Generated
        private boolean isUnique$set;
        @Generated
        private Boolean isUnique$value;
        @Generated
        private boolean isIndexable$set;
        @Generated
        private Boolean isIndexable$value;
        @Generated
        private boolean includeInNotification$set;
        @Generated
        private Boolean includeInNotification$value;
        @Generated
        private Boolean skipScrubbing;
        @Generated
        private Long searchWeight;
        @Generated
        private String indexType;
        @Generated
        private AttributeDefOptions options;
        @Generated
        private boolean isNew$set;
        @Generated
        private Boolean isNew$value;
        @Generated
        private List<Constraint> constraints;
        @Generated
        private Map<String, String> indexTypeESConfig;
        @Generated
        private Map<String, Map<String, String>> indexTypeESFields;
        @Generated
        private Map<String, List<String>> autoUpdateAttributes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AttributeDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AttributeDef instance, AttributeDefBuilder<?, ?> b) {
            b.name(instance.name);
            b.displayName(instance.displayName);
            b.description(instance.description);
            b.typeName(instance.typeName);
            b.defaultValue(instance.defaultValue);
            b.isOptional(instance.isOptional);
            b.cardinality(instance.cardinality);
            b.valuesMinCount(instance.valuesMinCount);
            b.valuesMaxCount(instance.valuesMaxCount);
            b.isUnique(instance.isUnique);
            b.isIndexable(instance.isIndexable);
            b.includeInNotification(instance.includeInNotification);
            b.skipScrubbing(instance.skipScrubbing);
            b.searchWeight(instance.searchWeight);
            b.indexType(instance.indexType);
            b.options(instance.options);
            b.isNew(instance.isNew);
            b.constraints(instance.constraints);
            b.indexTypeESConfig(instance.indexTypeESConfig);
            b.indexTypeESFields(instance.indexTypeESFields);
            b.autoUpdateAttributes(instance.autoUpdateAttributes);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B displayName(String displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        @Generated
        public B typeName(String typeName) {
            this.typeName = typeName;
            return (B)this.self();
        }

        @Generated
        public B defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return (B)this.self();
        }

        @Generated
        public B isOptional(Boolean isOptional) {
            this.isOptional$value = isOptional;
            this.isOptional$set = true;
            return (B)this.self();
        }

        @Generated
        public B cardinality(AtlanCustomAttributeCardinality cardinality) {
            this.cardinality$value = cardinality;
            this.cardinality$set = true;
            return (B)this.self();
        }

        @Generated
        public B valuesMinCount(Long valuesMinCount) {
            this.valuesMinCount$value = valuesMinCount;
            this.valuesMinCount$set = true;
            return (B)this.self();
        }

        @Generated
        public B valuesMaxCount(Long valuesMaxCount) {
            this.valuesMaxCount$value = valuesMaxCount;
            this.valuesMaxCount$set = true;
            return (B)this.self();
        }

        @Generated
        public B isUnique(Boolean isUnique) {
            this.isUnique$value = isUnique;
            this.isUnique$set = true;
            return (B)this.self();
        }

        @Generated
        public B isIndexable(Boolean isIndexable) {
            this.isIndexable$value = isIndexable;
            this.isIndexable$set = true;
            return (B)this.self();
        }

        @Generated
        public B includeInNotification(Boolean includeInNotification) {
            this.includeInNotification$value = includeInNotification;
            this.includeInNotification$set = true;
            return (B)this.self();
        }

        @Generated
        public B skipScrubbing(Boolean skipScrubbing) {
            this.skipScrubbing = skipScrubbing;
            return (B)this.self();
        }

        @Generated
        public B searchWeight(Long searchWeight) {
            this.searchWeight = searchWeight;
            return (B)this.self();
        }

        @Generated
        public B indexType(String indexType) {
            this.indexType = indexType;
            return (B)this.self();
        }

        @Generated
        public B options(AttributeDefOptions options) {
            this.options = options;
            return (B)this.self();
        }

        @Generated
        public B isNew(Boolean isNew) {
            this.isNew$value = isNew;
            this.isNew$set = true;
            return (B)this.self();
        }

        @Generated
        public B constraints(List<Constraint> constraints) {
            this.constraints = constraints;
            return (B)this.self();
        }

        @Generated
        public B indexTypeESConfig(Map<String, String> indexTypeESConfig) {
            this.indexTypeESConfig = indexTypeESConfig;
            return (B)this.self();
        }

        @Generated
        public B indexTypeESFields(Map<String, Map<String, String>> indexTypeESFields) {
            this.indexTypeESFields = indexTypeESFields;
            return (B)this.self();
        }

        @Generated
        public B autoUpdateAttributes(Map<String, List<String>> autoUpdateAttributes) {
            this.autoUpdateAttributes = autoUpdateAttributes;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AttributeDef.AttributeDefBuilder(super=" + super.toString() + ", name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", typeName=" + this.typeName + ", defaultValue=" + this.defaultValue + ", isOptional$value=" + this.isOptional$value + ", cardinality$value=" + this.cardinality$value + ", valuesMinCount$value=" + this.valuesMinCount$value + ", valuesMaxCount$value=" + this.valuesMaxCount$value + ", isUnique$value=" + this.isUnique$value + ", isIndexable$value=" + this.isIndexable$value + ", includeInNotification$value=" + this.includeInNotification$value + ", skipScrubbing=" + this.skipScrubbing + ", searchWeight=" + this.searchWeight + ", indexType=" + this.indexType + ", options=" + this.options + ", isNew$value=" + this.isNew$value + ", constraints=" + this.constraints + ", indexTypeESConfig=" + this.indexTypeESConfig + ", indexTypeESFields=" + this.indexTypeESFields + ", autoUpdateAttributes=" + this.autoUpdateAttributes + ")";
        }
    }
}

