/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.typedefs;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanCustomAttributePrimitiveType;
import com.atlan.serde.SetToStringSerializer;
import com.atlan.serde.StringToSetDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Set;
import lombok.Generated;

@JsonDeserialize(builder=AttributeDefOptionsBuilderImpl.class)
public class AttributeDefOptions
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    private static final Set<String> defaultTypes = Set.of("Database", "Schema", "View", "Table", "TablePartition", "MaterialisedView", "Column", "TableauSite", "TableauProject", "TableauWorkbook", "TableauWorksheet", "TableauDashboard", "TableauDatasource", "TableauDatasourceField", "TableauCalculatedField", "TableauFlow", "TableauMetric", "PowerBIWorkspace", "PowerBIDashboard", "PowerBIReport", "PowerBIDataset", "PowerBIDataflow", "PowerBITile", "PowerBIPage", "PowerBIDatasource", "PowerBITable", "PowerBIColumn", "PowerBIMeasure", "LookerDashboard", "LookerExplore", "LookerField", "LookerFolder", "LookerLook", "LookerModel", "LookerProject", "LookerQuery", "LookerTile", "LookerView", "MetabaseCollection", "MetabaseDashboard", "MetabaseQuestion", "ModeWorkspace", "ModeCollection", "ModeReport", "ModeQuery", "ModeChart", "SalesforceOrganization", "SalesforceDashboard", "SalesforceReport", "SalesforceObject", "SalesforceField", "S3Bucket", "S3Object", "Query", "Folder", "Collection", "Process", "ColumnProcess", "BIProcess", "AtlasGlossary", "AtlasGlossaryTerm", "AtlasGlossaryCategory");
    String description;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    Set<String> applicableEntityTypes;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    Set<String> customApplicableEntityTypes;
    Boolean allowSearch;
    String maxStrLength;
    Boolean allowFiltering;
    Boolean multiValueSelect;
    Boolean showInOverview;
    String isDeprecated;
    AtlanCustomAttributePrimitiveType primitiveType;
    Boolean isEnum;
    String enumType;
    String customType;
    Boolean isArchived;
    Long archivedAt;
    String archivedBy;
    String isSoftReference;
    String isAppendOnPartialUpdate;

    public static AttributeDefOptions of(AtlanCustomAttributePrimitiveType type, String optionsName) {
        Object builder = AttributeDefOptions.builder().primitiveType(type);
        switch (type) {
            case USERS: 
            case GROUPS: 
            case URL: 
            case SQL: {
                builder = ((AttributeDefOptionsBuilder)builder).customType(type.getValue());
                break;
            }
            case OPTIONS: {
                builder = ((AttributeDefOptionsBuilder)((AttributeDefOptionsBuilder)builder).isEnum(true)).enumType(optionsName);
                break;
            }
        }
        return ((AttributeDefOptionsBuilder)builder).build();
    }

    @Generated
    private static Set<String> $default$applicableEntityTypes() {
        return Set.of("Asset");
    }

    @Generated
    private static Set<String> $default$customApplicableEntityTypes() {
        return defaultTypes;
    }

    @Generated
    private static Boolean $default$allowSearch() {
        return false;
    }

    @Generated
    private static String $default$maxStrLength() {
        return "100000000";
    }

    @Generated
    private static Boolean $default$allowFiltering() {
        return true;
    }

    @Generated
    private static Boolean $default$multiValueSelect() {
        return false;
    }

    @Generated
    private static Boolean $default$showInOverview() {
        return false;
    }

    @Generated
    private static Boolean $default$isArchived() {
        return false;
    }

    @Generated
    protected AttributeDefOptions(AttributeDefOptionsBuilder<?, ?> b) {
        super(b);
        this.description = b.description;
        this.applicableEntityTypes = b.applicableEntityTypes$set ? b.applicableEntityTypes$value : AttributeDefOptions.$default$applicableEntityTypes();
        this.customApplicableEntityTypes = b.customApplicableEntityTypes$set ? b.customApplicableEntityTypes$value : AttributeDefOptions.$default$customApplicableEntityTypes();
        this.allowSearch = b.allowSearch$set ? b.allowSearch$value : AttributeDefOptions.$default$allowSearch();
        this.maxStrLength = b.maxStrLength$set ? b.maxStrLength$value : AttributeDefOptions.$default$maxStrLength();
        this.allowFiltering = b.allowFiltering$set ? b.allowFiltering$value : AttributeDefOptions.$default$allowFiltering();
        this.multiValueSelect = b.multiValueSelect$set ? b.multiValueSelect$value : AttributeDefOptions.$default$multiValueSelect();
        this.showInOverview = b.showInOverview$set ? b.showInOverview$value : AttributeDefOptions.$default$showInOverview();
        this.isDeprecated = b.isDeprecated;
        this.primitiveType = b.primitiveType;
        this.isEnum = b.isEnum;
        this.enumType = b.enumType;
        this.customType = b.customType;
        this.isArchived = b.isArchived$set ? b.isArchived$value : AttributeDefOptions.$default$isArchived();
        this.archivedAt = b.archivedAt;
        this.archivedBy = b.archivedBy;
        this.isSoftReference = b.isSoftReference;
        this.isAppendOnPartialUpdate = b.isAppendOnPartialUpdate;
    }

    @Generated
    public static AttributeDefOptionsBuilder<?, ?> builder() {
        return new AttributeDefOptionsBuilderImpl();
    }

    @Generated
    public AttributeDefOptionsBuilder<?, ?> toBuilder() {
        return new AttributeDefOptionsBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getApplicableEntityTypes() {
        return this.applicableEntityTypes;
    }

    @Generated
    public Set<String> getCustomApplicableEntityTypes() {
        return this.customApplicableEntityTypes;
    }

    @Generated
    public Boolean getAllowSearch() {
        return this.allowSearch;
    }

    @Generated
    public String getMaxStrLength() {
        return this.maxStrLength;
    }

    @Generated
    public Boolean getAllowFiltering() {
        return this.allowFiltering;
    }

    @Generated
    public Boolean getMultiValueSelect() {
        return this.multiValueSelect;
    }

    @Generated
    public Boolean getShowInOverview() {
        return this.showInOverview;
    }

    @Generated
    public String getIsDeprecated() {
        return this.isDeprecated;
    }

    @Generated
    public AtlanCustomAttributePrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    @Generated
    public Boolean getIsEnum() {
        return this.isEnum;
    }

    @Generated
    public String getEnumType() {
        return this.enumType;
    }

    @Generated
    public String getCustomType() {
        return this.customType;
    }

    @Generated
    public Boolean getIsArchived() {
        return this.isArchived;
    }

    @Generated
    public Long getArchivedAt() {
        return this.archivedAt;
    }

    @Generated
    public String getArchivedBy() {
        return this.archivedBy;
    }

    @Generated
    public String getIsSoftReference() {
        return this.isSoftReference;
    }

    @Generated
    public String getIsAppendOnPartialUpdate() {
        return this.isAppendOnPartialUpdate;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonDeserialize(using=StringToSetDeserializer.class)
    @Generated
    public void setApplicableEntityTypes(Set<String> applicableEntityTypes) {
        this.applicableEntityTypes = applicableEntityTypes;
    }

    @JsonDeserialize(using=StringToSetDeserializer.class)
    @Generated
    public void setCustomApplicableEntityTypes(Set<String> customApplicableEntityTypes) {
        this.customApplicableEntityTypes = customApplicableEntityTypes;
    }

    @Generated
    public void setAllowSearch(Boolean allowSearch) {
        this.allowSearch = allowSearch;
    }

    @Generated
    public void setMaxStrLength(String maxStrLength) {
        this.maxStrLength = maxStrLength;
    }

    @Generated
    public void setAllowFiltering(Boolean allowFiltering) {
        this.allowFiltering = allowFiltering;
    }

    @Generated
    public void setMultiValueSelect(Boolean multiValueSelect) {
        this.multiValueSelect = multiValueSelect;
    }

    @Generated
    public void setShowInOverview(Boolean showInOverview) {
        this.showInOverview = showInOverview;
    }

    @Generated
    public void setIsDeprecated(String isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    @Generated
    public void setPrimitiveType(AtlanCustomAttributePrimitiveType primitiveType) {
        this.primitiveType = primitiveType;
    }

    @Generated
    public void setIsEnum(Boolean isEnum) {
        this.isEnum = isEnum;
    }

    @Generated
    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    @Generated
    public void setCustomType(String customType) {
        this.customType = customType;
    }

    @Generated
    public void setIsArchived(Boolean isArchived) {
        this.isArchived = isArchived;
    }

    @Generated
    public void setArchivedAt(Long archivedAt) {
        this.archivedAt = archivedAt;
    }

    @Generated
    public void setArchivedBy(String archivedBy) {
        this.archivedBy = archivedBy;
    }

    @Generated
    public void setIsSoftReference(String isSoftReference) {
        this.isSoftReference = isSoftReference;
    }

    @Generated
    public void setIsAppendOnPartialUpdate(String isAppendOnPartialUpdate) {
        this.isAppendOnPartialUpdate = isAppendOnPartialUpdate;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeDefOptions)) {
            return false;
        }
        AttributeDefOptions other = (AttributeDefOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowSearch = this.getAllowSearch();
        Boolean other$allowSearch = other.getAllowSearch();
        if (this$allowSearch == null ? other$allowSearch != null : !((Object)this$allowSearch).equals(other$allowSearch)) {
            return false;
        }
        Boolean this$allowFiltering = this.getAllowFiltering();
        Boolean other$allowFiltering = other.getAllowFiltering();
        if (this$allowFiltering == null ? other$allowFiltering != null : !((Object)this$allowFiltering).equals(other$allowFiltering)) {
            return false;
        }
        Boolean this$multiValueSelect = this.getMultiValueSelect();
        Boolean other$multiValueSelect = other.getMultiValueSelect();
        if (this$multiValueSelect == null ? other$multiValueSelect != null : !((Object)this$multiValueSelect).equals(other$multiValueSelect)) {
            return false;
        }
        Boolean this$showInOverview = this.getShowInOverview();
        Boolean other$showInOverview = other.getShowInOverview();
        if (this$showInOverview == null ? other$showInOverview != null : !((Object)this$showInOverview).equals(other$showInOverview)) {
            return false;
        }
        Boolean this$isEnum = this.getIsEnum();
        Boolean other$isEnum = other.getIsEnum();
        if (this$isEnum == null ? other$isEnum != null : !((Object)this$isEnum).equals(other$isEnum)) {
            return false;
        }
        Boolean this$isArchived = this.getIsArchived();
        Boolean other$isArchived = other.getIsArchived();
        if (this$isArchived == null ? other$isArchived != null : !((Object)this$isArchived).equals(other$isArchived)) {
            return false;
        }
        Long this$archivedAt = this.getArchivedAt();
        Long other$archivedAt = other.getArchivedAt();
        if (this$archivedAt == null ? other$archivedAt != null : !((Object)this$archivedAt).equals(other$archivedAt)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$applicableEntityTypes = this.getApplicableEntityTypes();
        Set<String> other$applicableEntityTypes = other.getApplicableEntityTypes();
        if (this$applicableEntityTypes == null ? other$applicableEntityTypes != null : !((Object)this$applicableEntityTypes).equals(other$applicableEntityTypes)) {
            return false;
        }
        Set<String> this$customApplicableEntityTypes = this.getCustomApplicableEntityTypes();
        Set<String> other$customApplicableEntityTypes = other.getCustomApplicableEntityTypes();
        if (this$customApplicableEntityTypes == null ? other$customApplicableEntityTypes != null : !((Object)this$customApplicableEntityTypes).equals(other$customApplicableEntityTypes)) {
            return false;
        }
        String this$maxStrLength = this.getMaxStrLength();
        String other$maxStrLength = other.getMaxStrLength();
        if (this$maxStrLength == null ? other$maxStrLength != null : !this$maxStrLength.equals(other$maxStrLength)) {
            return false;
        }
        String this$isDeprecated = this.getIsDeprecated();
        String other$isDeprecated = other.getIsDeprecated();
        if (this$isDeprecated == null ? other$isDeprecated != null : !this$isDeprecated.equals(other$isDeprecated)) {
            return false;
        }
        AtlanCustomAttributePrimitiveType this$primitiveType = this.getPrimitiveType();
        AtlanCustomAttributePrimitiveType other$primitiveType = other.getPrimitiveType();
        if (this$primitiveType == null ? other$primitiveType != null : !this$primitiveType.equals(other$primitiveType)) {
            return false;
        }
        String this$enumType = this.getEnumType();
        String other$enumType = other.getEnumType();
        if (this$enumType == null ? other$enumType != null : !this$enumType.equals(other$enumType)) {
            return false;
        }
        String this$customType = this.getCustomType();
        String other$customType = other.getCustomType();
        if (this$customType == null ? other$customType != null : !this$customType.equals(other$customType)) {
            return false;
        }
        String this$archivedBy = this.getArchivedBy();
        String other$archivedBy = other.getArchivedBy();
        if (this$archivedBy == null ? other$archivedBy != null : !this$archivedBy.equals(other$archivedBy)) {
            return false;
        }
        String this$isSoftReference = this.getIsSoftReference();
        String other$isSoftReference = other.getIsSoftReference();
        if (this$isSoftReference == null ? other$isSoftReference != null : !this$isSoftReference.equals(other$isSoftReference)) {
            return false;
        }
        String this$isAppendOnPartialUpdate = this.getIsAppendOnPartialUpdate();
        String other$isAppendOnPartialUpdate = other.getIsAppendOnPartialUpdate();
        return !(this$isAppendOnPartialUpdate == null ? other$isAppendOnPartialUpdate != null : !this$isAppendOnPartialUpdate.equals(other$isAppendOnPartialUpdate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeDefOptions;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowSearch = this.getAllowSearch();
        result = result * 59 + ($allowSearch == null ? 43 : ((Object)$allowSearch).hashCode());
        Boolean $allowFiltering = this.getAllowFiltering();
        result = result * 59 + ($allowFiltering == null ? 43 : ((Object)$allowFiltering).hashCode());
        Boolean $multiValueSelect = this.getMultiValueSelect();
        result = result * 59 + ($multiValueSelect == null ? 43 : ((Object)$multiValueSelect).hashCode());
        Boolean $showInOverview = this.getShowInOverview();
        result = result * 59 + ($showInOverview == null ? 43 : ((Object)$showInOverview).hashCode());
        Boolean $isEnum = this.getIsEnum();
        result = result * 59 + ($isEnum == null ? 43 : ((Object)$isEnum).hashCode());
        Boolean $isArchived = this.getIsArchived();
        result = result * 59 + ($isArchived == null ? 43 : ((Object)$isArchived).hashCode());
        Long $archivedAt = this.getArchivedAt();
        result = result * 59 + ($archivedAt == null ? 43 : ((Object)$archivedAt).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $applicableEntityTypes = this.getApplicableEntityTypes();
        result = result * 59 + ($applicableEntityTypes == null ? 43 : ((Object)$applicableEntityTypes).hashCode());
        Set<String> $customApplicableEntityTypes = this.getCustomApplicableEntityTypes();
        result = result * 59 + ($customApplicableEntityTypes == null ? 43 : ((Object)$customApplicableEntityTypes).hashCode());
        String $maxStrLength = this.getMaxStrLength();
        result = result * 59 + ($maxStrLength == null ? 43 : $maxStrLength.hashCode());
        String $isDeprecated = this.getIsDeprecated();
        result = result * 59 + ($isDeprecated == null ? 43 : $isDeprecated.hashCode());
        AtlanCustomAttributePrimitiveType $primitiveType = this.getPrimitiveType();
        result = result * 59 + ($primitiveType == null ? 43 : $primitiveType.hashCode());
        String $enumType = this.getEnumType();
        result = result * 59 + ($enumType == null ? 43 : $enumType.hashCode());
        String $customType = this.getCustomType();
        result = result * 59 + ($customType == null ? 43 : $customType.hashCode());
        String $archivedBy = this.getArchivedBy();
        result = result * 59 + ($archivedBy == null ? 43 : $archivedBy.hashCode());
        String $isSoftReference = this.getIsSoftReference();
        result = result * 59 + ($isSoftReference == null ? 43 : $isSoftReference.hashCode());
        String $isAppendOnPartialUpdate = this.getIsAppendOnPartialUpdate();
        result = result * 59 + ($isAppendOnPartialUpdate == null ? 43 : $isAppendOnPartialUpdate.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AttributeDefOptionsBuilderImpl
    extends AttributeDefOptionsBuilder<AttributeDefOptions, AttributeDefOptionsBuilderImpl> {
        @Generated
        private AttributeDefOptionsBuilderImpl() {
        }

        @Override
        @Generated
        protected AttributeDefOptionsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AttributeDefOptions build() {
            return new AttributeDefOptions(this);
        }
    }

    @Generated
    public static abstract class AttributeDefOptionsBuilder<C extends AttributeDefOptions, B extends AttributeDefOptionsBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String description;
        @Generated
        private boolean applicableEntityTypes$set;
        @Generated
        private Set<String> applicableEntityTypes$value;
        @Generated
        private boolean customApplicableEntityTypes$set;
        @Generated
        private Set<String> customApplicableEntityTypes$value;
        @Generated
        private boolean allowSearch$set;
        @Generated
        private Boolean allowSearch$value;
        @Generated
        private boolean maxStrLength$set;
        @Generated
        private String maxStrLength$value;
        @Generated
        private boolean allowFiltering$set;
        @Generated
        private Boolean allowFiltering$value;
        @Generated
        private boolean multiValueSelect$set;
        @Generated
        private Boolean multiValueSelect$value;
        @Generated
        private boolean showInOverview$set;
        @Generated
        private Boolean showInOverview$value;
        @Generated
        private String isDeprecated;
        @Generated
        private AtlanCustomAttributePrimitiveType primitiveType;
        @Generated
        private Boolean isEnum;
        @Generated
        private String enumType;
        @Generated
        private String customType;
        @Generated
        private boolean isArchived$set;
        @Generated
        private Boolean isArchived$value;
        @Generated
        private Long archivedAt;
        @Generated
        private String archivedBy;
        @Generated
        private String isSoftReference;
        @Generated
        private String isAppendOnPartialUpdate;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AttributeDefOptionsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AttributeDefOptions instance, AttributeDefOptionsBuilder<?, ?> b) {
            b.description(instance.description);
            b.applicableEntityTypes(instance.applicableEntityTypes);
            b.customApplicableEntityTypes(instance.customApplicableEntityTypes);
            b.allowSearch(instance.allowSearch);
            b.maxStrLength(instance.maxStrLength);
            b.allowFiltering(instance.allowFiltering);
            b.multiValueSelect(instance.multiValueSelect);
            b.showInOverview(instance.showInOverview);
            b.isDeprecated(instance.isDeprecated);
            b.primitiveType(instance.primitiveType);
            b.isEnum(instance.isEnum);
            b.enumType(instance.enumType);
            b.customType(instance.customType);
            b.isArchived(instance.isArchived);
            b.archivedAt(instance.archivedAt);
            b.archivedBy(instance.archivedBy);
            b.isSoftReference(instance.isSoftReference);
            b.isAppendOnPartialUpdate(instance.isAppendOnPartialUpdate);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @Generated
        public B applicableEntityTypes(Set<String> applicableEntityTypes) {
            this.applicableEntityTypes$value = applicableEntityTypes;
            this.applicableEntityTypes$set = true;
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @Generated
        public B customApplicableEntityTypes(Set<String> customApplicableEntityTypes) {
            this.customApplicableEntityTypes$value = customApplicableEntityTypes;
            this.customApplicableEntityTypes$set = true;
            return (B)this.self();
        }

        @Generated
        public B allowSearch(Boolean allowSearch) {
            this.allowSearch$value = allowSearch;
            this.allowSearch$set = true;
            return (B)this.self();
        }

        @Generated
        public B maxStrLength(String maxStrLength) {
            this.maxStrLength$value = maxStrLength;
            this.maxStrLength$set = true;
            return (B)this.self();
        }

        @Generated
        public B allowFiltering(Boolean allowFiltering) {
            this.allowFiltering$value = allowFiltering;
            this.allowFiltering$set = true;
            return (B)this.self();
        }

        @Generated
        public B multiValueSelect(Boolean multiValueSelect) {
            this.multiValueSelect$value = multiValueSelect;
            this.multiValueSelect$set = true;
            return (B)this.self();
        }

        @Generated
        public B showInOverview(Boolean showInOverview) {
            this.showInOverview$value = showInOverview;
            this.showInOverview$set = true;
            return (B)this.self();
        }

        @Generated
        public B isDeprecated(String isDeprecated) {
            this.isDeprecated = isDeprecated;
            return (B)this.self();
        }

        @Generated
        public B primitiveType(AtlanCustomAttributePrimitiveType primitiveType) {
            this.primitiveType = primitiveType;
            return (B)this.self();
        }

        @Generated
        public B isEnum(Boolean isEnum) {
            this.isEnum = isEnum;
            return (B)this.self();
        }

        @Generated
        public B enumType(String enumType) {
            this.enumType = enumType;
            return (B)this.self();
        }

        @Generated
        public B customType(String customType) {
            this.customType = customType;
            return (B)this.self();
        }

        @Generated
        public B isArchived(Boolean isArchived) {
            this.isArchived$value = isArchived;
            this.isArchived$set = true;
            return (B)this.self();
        }

        @Generated
        public B archivedAt(Long archivedAt) {
            this.archivedAt = archivedAt;
            return (B)this.self();
        }

        @Generated
        public B archivedBy(String archivedBy) {
            this.archivedBy = archivedBy;
            return (B)this.self();
        }

        @Generated
        public B isSoftReference(String isSoftReference) {
            this.isSoftReference = isSoftReference;
            return (B)this.self();
        }

        @Generated
        public B isAppendOnPartialUpdate(String isAppendOnPartialUpdate) {
            this.isAppendOnPartialUpdate = isAppendOnPartialUpdate;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AttributeDefOptions.AttributeDefOptionsBuilder(super=" + super.toString() + ", description=" + this.description + ", applicableEntityTypes$value=" + this.applicableEntityTypes$value + ", customApplicableEntityTypes$value=" + this.customApplicableEntityTypes$value + ", allowSearch$value=" + this.allowSearch$value + ", maxStrLength$value=" + this.maxStrLength$value + ", allowFiltering$value=" + this.allowFiltering$value + ", multiValueSelect$value=" + this.multiValueSelect$value + ", showInOverview$value=" + this.showInOverview$value + ", isDeprecated=" + this.isDeprecated + ", primitiveType=" + this.primitiveType + ", isEnum=" + this.isEnum + ", enumType=" + this.enumType + ", customType=" + this.customType + ", isArchived$value=" + this.isArchived$value + ", archivedAt=" + this.archivedAt + ", archivedBy=" + this.archivedBy + ", isSoftReference=" + this.isSoftReference + ", isAppendOnPartialUpdate=" + this.isAppendOnPartialUpdate + ")";
        }
    }
}

