/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.typedefs;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.cache.ClassificationCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanClassificationColor;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.ClassificationOptions;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=ClassificationDefBuilderImpl.class)
public class ClassificationDef
extends TypeDef {
    private static final long serialVersionUID = 2L;
    AtlanTypeCategory category;
    ClassificationOptions options;
    List<String> superTypes;
    List<String> entityTypes;
    List<String> subTypes;

    public static ClassificationDef toCreate(String displayName, AtlanClassificationColor color) {
        return ((ClassificationDefBuilder)((ClassificationDefBuilder)((ClassificationDefBuilder)ClassificationDef.builder().name(displayName)).displayName(displayName)).options(ClassificationOptions.of(color))).build();
    }

    public ClassificationDef create() throws AtlanException {
        TypeDefResponse response = TypeDefsEndpoint.createTypeDef(this);
        if (response != null && !response.getClassificationDefs().isEmpty()) {
            return response.getClassificationDefs().get(0);
        }
        return null;
    }

    public static void purge(String displayName) throws AtlanException {
        String internalName = ClassificationCache.getIdForName(displayName);
        if (internalName == null) {
            throw new InvalidRequestException("Unable to find a classification with the name: " + displayName, "name", "ATLAN-CLIENT-400-011", 400, null);
        }
        TypeDefsEndpoint.purgeTypeDef(internalName);
    }

    @Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.CLASSIFICATION;
    }

    @Generated
    protected ClassificationDef(ClassificationDefBuilder<?, ?> b) {
        super((TypeDef.TypeDefBuilder<?, ?>)b);
        this.category = b.category$set ? b.category$value : ClassificationDef.$default$category();
        this.options = b.options;
        this.superTypes = b.superTypes;
        this.entityTypes = b.entityTypes;
        this.subTypes = b.subTypes;
    }

    @Generated
    public static ClassificationDefBuilder<?, ?> builder() {
        return new ClassificationDefBuilderImpl();
    }

    @Generated
    public ClassificationDefBuilder<?, ?> toBuilder() {
        return new ClassificationDefBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public ClassificationOptions getOptions() {
        return this.options;
    }

    @Generated
    public List<String> getSuperTypes() {
        return this.superTypes;
    }

    @Generated
    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    @Generated
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    @Generated
    public void setOptions(ClassificationOptions options) {
        this.options = options;
    }

    @Generated
    public void setSuperTypes(List<String> superTypes) {
        this.superTypes = superTypes;
    }

    @Generated
    public void setEntityTypes(List<String> entityTypes) {
        this.entityTypes = entityTypes;
    }

    @Generated
    public void setSubTypes(List<String> subTypes) {
        this.subTypes = subTypes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassificationDef)) {
            return false;
        }
        ClassificationDef other = (ClassificationDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlanTypeCategory this$category = this.getCategory();
        AtlanTypeCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        ClassificationOptions this$options = this.getOptions();
        ClassificationOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        List<String> this$superTypes = this.getSuperTypes();
        List<String> other$superTypes = other.getSuperTypes();
        if (this$superTypes == null ? other$superTypes != null : !((Object)this$superTypes).equals(other$superTypes)) {
            return false;
        }
        List<String> this$entityTypes = this.getEntityTypes();
        List<String> other$entityTypes = other.getEntityTypes();
        if (this$entityTypes == null ? other$entityTypes != null : !((Object)this$entityTypes).equals(other$entityTypes)) {
            return false;
        }
        List<String> this$subTypes = this.getSubTypes();
        List<String> other$subTypes = other.getSubTypes();
        return !(this$subTypes == null ? other$subTypes != null : !((Object)this$subTypes).equals(other$subTypes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassificationDef;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AtlanTypeCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        ClassificationOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        List<String> $superTypes = this.getSuperTypes();
        result = result * 59 + ($superTypes == null ? 43 : ((Object)$superTypes).hashCode());
        List<String> $entityTypes = this.getEntityTypes();
        result = result * 59 + ($entityTypes == null ? 43 : ((Object)$entityTypes).hashCode());
        List<String> $subTypes = this.getSubTypes();
        result = result * 59 + ($subTypes == null ? 43 : ((Object)$subTypes).hashCode());
        return result;
    }

    @Override
    @Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }

    @Override
    @Generated
    public void setCategory(AtlanTypeCategory category) {
        this.category = category;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ClassificationDefBuilderImpl
    extends ClassificationDefBuilder<ClassificationDef, ClassificationDefBuilderImpl> {
        @Generated
        private ClassificationDefBuilderImpl() {
        }

        @Override
        @Generated
        protected ClassificationDefBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ClassificationDef build() {
            return new ClassificationDef(this);
        }
    }

    @Generated
    public static abstract class ClassificationDefBuilder<C extends ClassificationDef, B extends ClassificationDefBuilder<C, B>>
    extends TypeDef.TypeDefBuilder<C, B> {
        @Generated
        private boolean category$set;
        @Generated
        private AtlanTypeCategory category$value;
        @Generated
        private ClassificationOptions options;
        @Generated
        private List<String> superTypes;
        @Generated
        private List<String> entityTypes;
        @Generated
        private List<String> subTypes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ClassificationDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ClassificationDef instance, ClassificationDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.options(instance.options);
            b.superTypes(instance.superTypes);
            b.entityTypes(instance.entityTypes);
            b.subTypes(instance.subTypes);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B category(AtlanTypeCategory category) {
            this.category$value = category;
            this.category$set = true;
            return (B)this.self();
        }

        @Generated
        public B options(ClassificationOptions options) {
            this.options = options;
            return (B)this.self();
        }

        @Generated
        public B superTypes(List<String> superTypes) {
            this.superTypes = superTypes;
            return (B)this.self();
        }

        @Generated
        public B entityTypes(List<String> entityTypes) {
            this.entityTypes = entityTypes;
            return (B)this.self();
        }

        @Generated
        public B subTypes(List<String> subTypes) {
            this.subTypes = subTypes;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ClassificationDef.ClassificationDefBuilder(super=" + super.toString() + ", category$value=" + this.category$value + ", options=" + this.options + ", superTypes=" + this.superTypes + ", entityTypes=" + this.entityTypes + ", subTypes=" + this.subTypes + ")";
        }
    }
}

