/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.workflow;

import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanWorkflowPhase;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowSearchRequest;
import com.atlan.model.workflow.WorkflowSearchResult;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.net.ApiResource;
import com.atlan.net.HttpClient;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class WorkflowResponse
extends ApiResource {
    private static final long serialVersionUID = 2L;
    WorkflowMetadata metadata;
    WorkflowSpec spec;
    List<Object> payload;

    public AtlanWorkflowPhase monitorStatus(Logger log) throws AtlanException, InterruptedException {
        if (this.getMetadata() != null && this.getMetadata().getName() != null) {
            String workflowName = this.getMetadata().getName();
            AtlanWorkflowPhase status = null;
            do {
                WorkflowSearchResult runDetails;
                if ((runDetails = WorkflowSearchRequest.findLatestRun(workflowName)) != null) {
                    status = runDetails.getStatus();
                }
                log.info("Workflow status: {}", (Object)status);
                Thread.sleep(HttpClient.waitTime(5).toMillis());
            } while (status != AtlanWorkflowPhase.SUCCESS && status != AtlanWorkflowPhase.ERROR && status != AtlanWorkflowPhase.FAILED);
            return status;
        }
        log.info("... skipping workflow monitoring \u2014 nothing to monitor.");
        return null;
    }

    @Generated
    public WorkflowResponse() {
    }

    @Generated
    public WorkflowMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public WorkflowSpec getSpec() {
        return this.spec;
    }

    @Generated
    public List<Object> getPayload() {
        return this.payload;
    }

    @Generated
    public void setMetadata(WorkflowMetadata metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setSpec(WorkflowSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setPayload(List<Object> payload) {
        this.payload = payload;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowResponse(metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ", payload=" + this.getPayload() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowResponse)) {
            return false;
        }
        WorkflowResponse other = (WorkflowResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WorkflowMetadata this$metadata = this.getMetadata();
        WorkflowMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        WorkflowSpec this$spec = this.getSpec();
        WorkflowSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        List<Object> this$payload = this.getPayload();
        List<Object> other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WorkflowMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        WorkflowSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        List<Object> $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }
}

