/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.workflow;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.NestedSortValue;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import com.atlan.api.WorkflowsEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.workflow.WorkflowSearchResponse;
import com.atlan.model.workflow.WorkflowSearchResult;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=WorkflowSearchRequestBuilderImpl.class)
public class WorkflowSearchRequest
extends IndexSearchDSL {
    private static final long serialVersionUID = 2L;

    public WorkflowSearchResponse search() throws AtlanException {
        return WorkflowsEndpoint.searchRuns(this);
    }

    public static WorkflowSearchResult findLatestRun(String workflowName) throws AtlanException {
        List<WorkflowSearchResult> results;
        SortOptions sort = SortOptions.of(s -> s.field(FieldSort.of(f -> f.field("metadata.creationTimestamp").order(SortOrder.Desc).nested(NestedSortValue.of(v -> v.path("metadata"))))));
        Query term = TermQuery.of(t -> t.field("spec.workflowTemplateRef.name.keyword").value(workflowName))._toQuery();
        Query nested = NestedQuery.of(n -> n.path("spec").query(term))._toQuery();
        Query query = BoolQuery.of(b -> b.filter(nested, new Query[0]))._toQuery();
        IndexSearchDSL request = ((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)WorkflowSearchRequest.builder().from(0)).size(10)).sortOption(sort)).query(query)).build();
        WorkflowSearchResponse response = WorkflowsEndpoint.searchRuns((WorkflowSearchRequest)request);
        if (response != null && (results = response.getHits().getHits()) != null && !results.isEmpty()) {
            return results.get(0);
        }
        return null;
    }

    public static List<WorkflowSearchResult> findByType(String prefix, int maxResults) throws AtlanException {
        SortOptions sort = SortOptions.of(s -> s.field(FieldSort.of(f -> f.field("metadata.creationTimestamp").order(SortOrder.Desc).nested(NestedSortValue.of(v -> v.path("metadata"))))));
        Query term = PrefixQuery.of(t -> t.field("metadata.name.keyword").value(prefix))._toQuery();
        Query nested = NestedQuery.of(n -> n.path("metadata").query(term))._toQuery();
        Query query = BoolQuery.of(b -> b.filter(nested, new Query[0]))._toQuery();
        IndexSearchDSL request = ((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)WorkflowSearchRequest.builder().from(0)).size(maxResults)).sortOption(sort)).query(query)).build();
        WorkflowSearchResponse response = WorkflowsEndpoint.search((WorkflowSearchRequest)request);
        if (response != null && response.getHits() != null) {
            return response.getHits().getHits();
        }
        return null;
    }

    @Generated
    protected WorkflowSearchRequest(WorkflowSearchRequestBuilder<?, ?> b) {
        super((IndexSearchDSL.IndexSearchDSLBuilder<?, ?>)b);
    }

    @Generated
    public static WorkflowSearchRequestBuilder<?, ?> builder() {
        return new WorkflowSearchRequestBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowSearchRequest()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowSearchRequest)) {
            return false;
        }
        WorkflowSearchRequest other = (WorkflowSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowSearchRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class WorkflowSearchRequestBuilderImpl
    extends WorkflowSearchRequestBuilder<WorkflowSearchRequest, WorkflowSearchRequestBuilderImpl> {
        @Generated
        private WorkflowSearchRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected WorkflowSearchRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WorkflowSearchRequest build() {
            return new WorkflowSearchRequest(this);
        }
    }

    @Generated
    public static abstract class WorkflowSearchRequestBuilder<C extends WorkflowSearchRequest, B extends WorkflowSearchRequestBuilder<C, B>>
    extends IndexSearchDSL.IndexSearchDSLBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WorkflowSearchRequest.WorkflowSearchRequestBuilder(super=" + super.toString() + ")";
        }
    }
}

