/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.net.HttpHeaders;
import com.atlan.net.RequestMetrics;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

abstract class AbstractAtlanResponse<T> {
    int code;
    HttpHeaders headers;
    RequestMetrics metrics;
    T body;
    int numRetries;

    public final int code() {
        return this.code;
    }

    public final HttpHeaders headers() {
        return this.headers;
    }

    public final T body() {
        return this.body;
    }

    public Instant date() {
        Optional<String> dateStr = this.headers.firstValue("Date");
        if (!dateStr.isPresent()) {
            return null;
        }
        return ZonedDateTime.parse(dateStr.get(), DateTimeFormatter.RFC_1123_DATE_TIME).toInstant();
    }

    protected AbstractAtlanResponse(int code, HttpHeaders headers, T body) {
        Objects.requireNonNull(headers);
        Objects.requireNonNull(body);
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    @Generated
    public RequestMetrics metrics() {
        return this.metrics;
    }

    @Generated
    AbstractAtlanResponse<T> metrics(RequestMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    @Generated
    public int numRetries() {
        return this.numRetries;
    }

    @Generated
    AbstractAtlanResponse<T> numRetries(int numRetries) {
        this.numRetries = numRetries;
        return this;
    }
}

