/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.AtlanResponseInterface;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseGetter;
import com.atlan.net.LiveAtlanResponseGetter;
import com.atlan.net.RequestOptions;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiResource
extends AtlanObject
implements AtlanResponseInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiResource.class);
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final AtlanResponseGetter atlanResponseGetter = new LiveAtlanResponseGetter();
    private transient AtlanResponse lastResponse;
    private transient JsonNode rawJsonObject;

    @Override
    public AtlanResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public void setLastResponse(AtlanResponse response) {
        this.lastResponse = response;
    }

    public JsonNode getRawJsonObject() {
        if (this.rawJsonObject == null && this.getLastResponse() != null) {
            try {
                this.rawJsonObject = Serde.mapper.readTree((String)this.getLastResponse().body());
            }
            catch (JsonProcessingException e) {
                log.error("Unable to parse raw JSON tree \u2014 invalid JSON? {}", this.getLastResponse().body(), (Object)e);
            }
        }
        return this.rawJsonObject;
    }

    public static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET).replaceAll("%5B", "[").replaceAll("%5D", "]");
    }

    public static String urlEncodeId(String id) throws InvalidRequestException {
        if (id == null) {
            throw new InvalidRequestException("Invalid null ID found for url path formatting. This can be because your string ID argument to the API method is null, or the relevant field in your Atlan object instance is null. ", null, null, 0, null);
        }
        return ApiResource.urlEncode(id);
    }

    public static <T extends ApiResource> T request(RequestMethod method, String url, AtlanObject payload, Class<T> clazz, RequestOptions options) throws AtlanException {
        ApiResource.checkNullTypedParams(url, payload);
        return ApiResource.request(method, url, payload.toJson(), clazz, options);
    }

    public static <T extends ApiResource> T request(RequestMethod method, String url, String body, Class<T> clazz, RequestOptions options) throws AtlanException {
        log.debug("({}) {} with: {}", new Object[]{method, url, body});
        ApiResource response = (ApiResource)atlanResponseGetter.request(method, url, body, clazz, options);
        if (log.isDebugEnabled()) {
            if (response != null) {
                if (Atlan.enableTelemetry) {
                    log.debug(" ... response ({}): {}", (Object)response.getLastResponse().metrics(), (Object)response.getRawJsonObject());
                } else {
                    log.debug(" ... response: {}", (Object)response.getRawJsonObject());
                }
            } else {
                log.debug(" ... empty response.");
            }
        }
        return (T)response;
    }

    public static void checkNullTypedParams(String url, AtlanObject params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Found null params for %s. Please pass empty params using param builder via `builder().build()` instead.", url));
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

