/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.Atlan;
import com.atlan.exception.ApiConnectionException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.net.ApiResource;
import com.atlan.net.HttpContent;
import com.atlan.net.HttpHeaders;
import com.atlan.net.RequestOptions;
import com.atlan.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public final class AtlanRequest {
    private final ApiResource.RequestMethod method;
    private final URL url;
    private final HttpContent content;
    private final HttpHeaders headers;
    private final String body;
    private final RequestOptions options;

    public AtlanRequest(ApiResource.RequestMethod method, String url, String body, RequestOptions options) throws AtlanException {
        try {
            this.body = body;
            this.options = options != null ? options : RequestOptions.getDefault();
            this.method = method;
            this.url = new URL(url);
            this.content = body == null || body.length() == 0 ? null : HttpContent.buildJSONEncodedContent(body);
            this.headers = AtlanRequest.buildHeaders(method, this.options);
        }
        catch (IOException e) {
            throw new ApiConnectionException(String.format("IOException during API request to Atlan (%s): %s Please check your internet connection and try again. If this problem persists,you should check Atlan's availability via a browser, or let us know at support@atlan.com.", Atlan.getBaseUrlSafe(), e.getMessage()), e);
        }
    }

    public AtlanRequest withAdditionalHeader(String name, String value) {
        return new AtlanRequest(this.method, this.url, this.content, this.headers.withAdditionalHeader(name, value), this.body, this.options);
    }

    private static HttpHeaders buildHeaders(ApiResource.RequestMethod method, RequestOptions options) throws AuthenticationException {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Accept", Arrays.asList("application/json"));
        headerMap.put("Accept-Charset", Arrays.asList(ApiResource.CHARSET.name()));
        String apiKey = options.getApiKey();
        if (apiKey == null) {
            throw new AuthenticationException("No API token provided. Set your API token using `Atlan.setApiToken(\"<API-TOKEN>\");`. You can generate API tokens from the Atlan Admin Center. See https://ask.atlan.com/hc/en-us/articles/8312649180049 for details or contact support at https://ask.atlan.com/hc/en-us/requests/new if you have any questions.", null, 0);
        }
        if (apiKey.isEmpty()) {
            throw new AuthenticationException("Your API token is invalid, as it is an empty string. You can double-check your API token from the Atlan Admin Center. See https://ask.atlan.com/hc/en-us/articles/8312649180049 for details or contact support at https://ask.atlan.com/hc/en-us/requests/new if you have any questions.", null, 0);
        }
        if (StringUtils.containsWhitespace(apiKey)) {
            throw new AuthenticationException("Your API token is invalid, as it contains whitespace. You can double-check your API token from the Atlan Admin Center. See https://ask.atlan.com/hc/en-us/articles/8312649180049 for details or contact support at https://ask.atlan.com/hc/en-us/requests/new if you have any questions.", null, 0);
        }
        headerMap.put("Authorization", Arrays.asList(String.format("Bearer %s", apiKey)));
        if (options.getAtlanVersion() == null) {
            throw new IllegalStateException("`atlanVersion` value must be set.");
        }
        headerMap.put("Atlan-Version", Arrays.asList(options.getAtlanVersion()));
        if (options.getAtlanAccount() != null) {
            headerMap.put("Atlan-Account", Arrays.asList(options.getAtlanAccount()));
        }
        if (options.getIdempotencyKey() != null) {
            headerMap.put("Idempotency-Key", Arrays.asList(options.getIdempotencyKey()));
        } else if (method == ApiResource.RequestMethod.POST) {
            headerMap.put("Idempotency-Key", Arrays.asList(UUID.randomUUID().toString()));
        }
        return HttpHeaders.of(headerMap);
    }

    @Generated
    public ApiResource.RequestMethod method() {
        return this.method;
    }

    @Generated
    public URL url() {
        return this.url;
    }

    @Generated
    public HttpContent content() {
        return this.content;
    }

    @Generated
    public HttpHeaders headers() {
        return this.headers;
    }

    @Generated
    public String body() {
        return this.body;
    }

    @Generated
    public RequestOptions options() {
        return this.options;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanRequest)) {
            return false;
        }
        AtlanRequest other = (AtlanRequest)o;
        ApiResource.RequestMethod this$method = this.method();
        ApiResource.RequestMethod other$method = other.method();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        URL this$url = this.url();
        URL other$url = other.url();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        HttpContent this$content = this.content();
        HttpContent other$content = other.content();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        HttpHeaders this$headers = this.headers();
        HttpHeaders other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.body();
        String other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        RequestOptions this$options = this.options();
        RequestOptions other$options = other.options();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiResource.RequestMethod $method = this.method();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        URL $url = this.url();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        HttpContent $content = this.content();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        HttpHeaders $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.body();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        RequestOptions $options = this.options();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AtlanRequest(method=" + this.method() + ", url=" + this.url() + ", content=" + this.content() + ", headers=" + this.headers() + ", body=" + this.body() + ", options=" + this.options() + ")";
    }

    @Generated
    protected AtlanRequest(ApiResource.RequestMethod method, URL url, HttpContent content, HttpHeaders headers, String body, RequestOptions options) {
        this.method = method;
        this.url = url;
        this.content = content;
        this.headers = headers;
        this.body = body;
        this.options = options;
    }
}

