/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.Atlan;
import com.atlan.exception.ApiConnectionException;
import com.atlan.exception.AtlanException;
import com.atlan.net.AbstractAtlanResponse;
import com.atlan.net.AtlanRequest;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseStream;
import com.atlan.net.RequestMetrics;
import com.atlan.serde.Serde;
import com.atlan.util.Stopwatch;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public static final Duration maxNetworkRetriesDelay = Duration.ofSeconds(5L);
    public static final Duration minNetworkRetriesDelay = Duration.ofMillis(500L);
    boolean networkRetriesSleep = true;

    protected HttpClient() {
    }

    public abstract AtlanResponse request(AtlanRequest var1) throws AtlanException;

    public AtlanResponseStream requestStream(AtlanRequest request) throws AtlanException {
        throw new UnsupportedOperationException("requestStream is unimplemented for this HttpClient");
    }

    private <T extends AbstractAtlanResponse<?>> T sendWithTelemetry(AtlanRequest request, RequestSendFunction<T> send) throws AtlanException {
        if (!Atlan.enableTelemetry) {
            return (T)((AbstractAtlanResponse)send.apply(request));
        }
        Stopwatch stopwatch = Stopwatch.startNew();
        AbstractAtlanResponse response = (AbstractAtlanResponse)send.apply(request);
        stopwatch.stop();
        RequestMetrics.embed(response, stopwatch.getElapsed());
        return (T)response;
    }

    public AtlanResponse requestWithTelemetry(AtlanRequest request) throws AtlanException {
        return this.sendWithTelemetry(request, this::request);
    }

    public <T extends AbstractAtlanResponse<?>> T sendWithRetries(AtlanRequest request, RequestSendFunction<T> send) throws AtlanException {
        ApiConnectionException requestException = null;
        AbstractAtlanResponse response = null;
        int retry = 0;
        while (true) {
            requestException = null;
            try {
                response = (AbstractAtlanResponse)send.apply(request);
            }
            catch (ApiConnectionException e) {
                requestException = e;
            }
            if (!this.shouldRetry(retry, requestException, request, response)) break;
            ++retry;
            try {
                Thread.sleep(this.sleepTime(retry).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (requestException != null) {
            throw requestException;
        }
        response.numRetries(retry);
        return (T)response;
    }

    public AtlanResponse requestWithRetries(AtlanRequest request) throws AtlanException {
        return this.sendWithRetries(request, r -> this.requestWithTelemetry(r));
    }

    protected static String buildUserAgentString() {
        Object userAgent = String.format("Atlan-SDK/1.0 Java/%s", "0.0.2");
        if (Atlan.getAppInfo() != null) {
            userAgent = (String)userAgent + " " + HttpClient.formatAppInfo(Atlan.getAppInfo());
        }
        return userAgent;
    }

    protected static String buildXAtlanClientUserAgentString() {
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "0.0.2");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Atlan");
        try {
            if (Atlan.getAppInfo() != null) {
                propertyMap.put("application", Serde.mapper.writeValueAsString(Atlan.getAppInfo()));
            }
            return Serde.mapper.writeValueAsString(propertyMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to build client user agent string.", e);
        }
    }

    private static String formatAppInfo(Map<String, String> info) {
        Object str = info.get("name");
        if (info.get("version") != null) {
            str = (String)str + String.format("/%s", info.get("version"));
        }
        if (info.get("url") != null) {
            str = (String)str + String.format(" (%s)", info.get("url"));
        }
        return str;
    }

    private <T extends AbstractAtlanResponse<?>> boolean shouldRetry(int numRetries, AtlanException exception, AtlanRequest request, T response) {
        if (numRetries >= request.options().getMaxNetworkRetries()) {
            log.error(" ... beyond max retries ({}), failing! If this is unexpected, you can try increasing the maximum retries through Atlan.setMaxNetworkRetries()", (Object)request.options().getMaxNetworkRetries());
            return false;
        }
        if (exception != null && exception.getCause() != null && (exception.getCause() instanceof ConnectException || exception.getCause() instanceof SocketTimeoutException)) {
            log.info(" ... network issue, will retry.");
            return true;
        }
        if (response != null && response.code() == 403) {
            log.info(" ... no permission for the operation (yet), will retry.");
            return true;
        }
        return response != null && response.code() >= 500;
    }

    private Duration sleepTime(int numRetries) {
        if (!this.networkRetriesSleep) {
            return Duration.ZERO;
        }
        return HttpClient.waitTime(numRetries);
    }

    public static Duration waitTime(int attempt) {
        Duration delay = Duration.ofNanos((long)((double)minNetworkRetriesDelay.toNanos() * Math.pow(2.0, attempt - 1)));
        if (delay.compareTo(maxNetworkRetriesDelay) > 0) {
            delay = maxNetworkRetriesDelay;
        }
        double jitter = ThreadLocalRandom.current().nextDouble(0.75, 1.0);
        if ((delay = Duration.ofNanos((long)((double)delay.toNanos() * jitter))).compareTo(minNetworkRetriesDelay) < 0) {
            delay = minNetworkRetriesDelay;
        }
        return delay;
    }

    @FunctionalInterface
    private static interface RequestSendFunction<R> {
        public R apply(AtlanRequest var1) throws AtlanException;
    }
}

