/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ConflictException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.exception.PermissionException;
import com.atlan.exception.RateLimitException;
import com.atlan.model.core.AtlanError;
import com.atlan.model.core.AtlanResponseInterface;
import com.atlan.net.ApiResource;
import com.atlan.net.AtlanRequest;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseGetter;
import com.atlan.net.HttpClient;
import com.atlan.net.HttpURLConnectionClient;
import com.atlan.net.RequestOptions;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;

public class LiveAtlanResponseGetter
implements AtlanResponseGetter {
    private final HttpClient httpClient;

    public LiveAtlanResponseGetter() {
        this(null);
    }

    public LiveAtlanResponseGetter(HttpClient httpClient) {
        this.httpClient = httpClient != null ? httpClient : LiveAtlanResponseGetter.buildDefaultHttpClient();
    }

    @Override
    public <T extends AtlanResponseInterface> T request(ApiResource.RequestMethod method, String url, String body, Class<T> clazz, RequestOptions options) throws AtlanException {
        AtlanRequest request = new AtlanRequest(method, url, body, options);
        AtlanResponse response = this.httpClient.requestWithRetries(request);
        int responseCode = response.code();
        String responseBody = (String)response.body();
        if (responseCode < 200 || responseCode >= 300) {
            LiveAtlanResponseGetter.handleApiError(response);
        }
        AtlanResponseInterface resource = null;
        if (clazz != null) {
            try {
                resource = (AtlanResponseInterface)Serde.mapper.readValue(responseBody, clazz);
            }
            catch (JsonProcessingException e) {
                LiveAtlanResponseGetter.raiseMalformedJsonError(responseBody, responseCode, e);
            }
        }
        if (resource != null) {
            resource.setLastResponse(response);
        }
        return (T)resource;
    }

    private static HttpClient buildDefaultHttpClient() {
        return new HttpURLConnectionClient();
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode, Throwable e) throws ApiException {
        String details = e == null ? "none" : e.getMessage();
        throw new ApiException(String.format("Invalid response object from API: %s. (HTTP response code was %d). Additional details: %s.", responseBody, responseCode, details), null, responseCode, e);
    }

    private static void handleApiError(AtlanResponse response) throws AtlanException {
        AtlanError error = null;
        AtlanException exception = null;
        int rc = response.code();
        if (rc == 500) {
            throw new InvalidRequestException((String)response.body(), null, null, rc, null);
        }
        try {
            error = (AtlanError)Serde.mapper.readValue((String)response.body(), AtlanError.class);
        }
        catch (JsonProcessingException e) {
            LiveAtlanResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), e);
        }
        if (error == null) {
            LiveAtlanResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), null);
        }
        switch (response.code()) {
            case 400: {
                exception = new InvalidRequestException(error.getErrorMessage(), null, error.getErrorCode(), response.code(), null);
                break;
            }
            case 404: {
                exception = new NotFoundException(error.getErrorMessage(), error.getErrorCode(), response.code(), null);
                break;
            }
            case 401: {
                exception = new AuthenticationException(error.getErrorMessage(), error.getErrorCode(), response.code());
                break;
            }
            case 403: {
                exception = new PermissionException(error.getErrorMessage(), error.getErrorCode(), response.code());
                break;
            }
            case 409: {
                exception = new ConflictException(error.getErrorMessage(), error.getErrorCode(), response.code(), null);
                break;
            }
            case 429: {
                exception = new RateLimitException(error.getErrorMessage(), null, error.getErrorCode(), response.code(), null);
                break;
            }
            default: {
                exception = new ApiException(error.getErrorMessage(), error.getErrorCode(), response.code(), null);
            }
        }
        exception.setAtlanError(error);
        throw exception;
    }
}

