/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.Atlan;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import lombok.Generated;

public class RequestOptions {
    private final String apiKey;
    private final String clientId;
    private final String idempotencyKey;
    private final String atlanAccount;
    private final String atlanVersion = "0.0.2";
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxNetworkRetries;
    private final Proxy connectionProxy;
    private final PasswordAuthentication proxyCredential;

    public static RequestOptions getDefault() {
        return new RequestOptions(Atlan.getApiToken(), Atlan.clientId, null, null, Atlan.getConnectTimeout(), Atlan.getReadTimeout(), Atlan.getMaxNetworkRetries(), Atlan.getConnectionProxy(), Atlan.getProxyCredential());
    }

    private RequestOptions(String apiKey, String clientId, String idempotencyKey, String atlanAccount, int connectTimeout, int readTimeout, int maxNetworkRetries, Proxy connectionProxy, PasswordAuthentication proxyCredential) {
        this.apiKey = apiKey;
        this.clientId = clientId;
        this.idempotencyKey = idempotencyKey;
        this.atlanAccount = atlanAccount;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.connectionProxy = connectionProxy;
        this.proxyCredential = proxyCredential;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public String getAtlanAccount() {
        return this.atlanAccount;
    }

    public String getAtlanVersion() {
        return "0.0.2";
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder().setApiKey(this.apiKey).setAtlanAccount(this.atlanAccount);
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty API key specified!");
        }
        return normalized;
    }

    private static String normalizeClientId(String clientId) {
        if (clientId == null) {
            return null;
        }
        String normalized = clientId.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty client_id specified!");
        }
        return normalized;
    }

    private static String normalizeIdempotencyKey(String idempotencyKey) {
        if (idempotencyKey == null) {
            return null;
        }
        String normalized = idempotencyKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Idempotency Key Specified!");
        }
        if (normalized.length() > 255) {
            throw new InvalidRequestOptionsException(String.format("Idempotency Key length was %d, which is larger than the 255 character maximum!", normalized.length()));
        }
        return normalized;
    }

    private static String normalizeAtlanAccount(String atlanAccount) {
        if (atlanAccount == null) {
            return null;
        }
        String normalized = atlanAccount.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Atlan account specified!");
        }
        return normalized;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestOptions)) {
            return false;
        }
        RequestOptions other = (RequestOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getMaxNetworkRetries() != other.getMaxNetworkRetries()) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$idempotencyKey = this.getIdempotencyKey();
        String other$idempotencyKey = other.getIdempotencyKey();
        if (this$idempotencyKey == null ? other$idempotencyKey != null : !this$idempotencyKey.equals(other$idempotencyKey)) {
            return false;
        }
        String this$atlanAccount = this.getAtlanAccount();
        String other$atlanAccount = other.getAtlanAccount();
        if (this$atlanAccount == null ? other$atlanAccount != null : !this$atlanAccount.equals(other$atlanAccount)) {
            return false;
        }
        String this$atlanVersion = this.getAtlanVersion();
        String other$atlanVersion = other.getAtlanVersion();
        if (this$atlanVersion == null ? other$atlanVersion != null : !this$atlanVersion.equals(other$atlanVersion)) {
            return false;
        }
        Proxy this$connectionProxy = this.getConnectionProxy();
        Proxy other$connectionProxy = other.getConnectionProxy();
        if (this$connectionProxy == null ? other$connectionProxy != null : !((Object)this$connectionProxy).equals(other$connectionProxy)) {
            return false;
        }
        PasswordAuthentication this$proxyCredential = this.getProxyCredential();
        PasswordAuthentication other$proxyCredential = other.getProxyCredential();
        return !(this$proxyCredential == null ? other$proxyCredential != null : !this$proxyCredential.equals(other$proxyCredential));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getMaxNetworkRetries();
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $idempotencyKey = this.getIdempotencyKey();
        result = result * 59 + ($idempotencyKey == null ? 43 : $idempotencyKey.hashCode());
        String $atlanAccount = this.getAtlanAccount();
        result = result * 59 + ($atlanAccount == null ? 43 : $atlanAccount.hashCode());
        String $atlanVersion = this.getAtlanVersion();
        result = result * 59 + ($atlanVersion == null ? 43 : $atlanVersion.hashCode());
        Proxy $connectionProxy = this.getConnectionProxy();
        result = result * 59 + ($connectionProxy == null ? 43 : ((Object)$connectionProxy).hashCode());
        PasswordAuthentication $proxyCredential = this.getProxyCredential();
        result = result * 59 + ($proxyCredential == null ? 43 : $proxyCredential.hashCode());
        return result;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Atlan.getApiToken();
        private String clientId = Atlan.clientId;
        private String idempotencyKey;
        private String atlanAccount;
        private int connectTimeout = Atlan.getConnectTimeout();
        private int readTimeout = Atlan.getReadTimeout();
        private int maxNetworkRetries = Atlan.getMaxNetworkRetries();
        private Proxy connectionProxy = Atlan.getConnectionProxy();
        private PasswordAuthentication proxyCredential = Atlan.getProxyCredential();

        public String getApiKey() {
            return this.apiKey;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public RequestOptionsBuilder setClientId(String clientId) {
            this.clientId = RequestOptions.normalizeClientId(clientId);
            return this;
        }

        public RequestOptionsBuilder clearClientId() {
            this.clientId = null;
            return this;
        }

        public RequestOptionsBuilder setIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public RequestOptionsBuilder setConnectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public RequestOptionsBuilder setReadTimeout(int timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public int getMaxNetworkRetries() {
            return this.maxNetworkRetries;
        }

        public RequestOptionsBuilder setMaxNetworkRetries(int maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public Proxy getConnectionProxy() {
            return this.connectionProxy;
        }

        public RequestOptionsBuilder setConnectionProxy(Proxy connectionProxy) {
            this.connectionProxy = connectionProxy;
            return this;
        }

        public PasswordAuthentication getProxyCredential() {
            return this.proxyCredential;
        }

        public RequestOptionsBuilder setProxyCredential(PasswordAuthentication proxyCredential) {
            this.proxyCredential = proxyCredential;
            return this;
        }

        public RequestOptionsBuilder clearIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public String getAtlanAccount() {
            return this.atlanAccount;
        }

        public RequestOptionsBuilder setAtlanAccount(String atlanAccount) {
            this.atlanAccount = atlanAccount;
            return this;
        }

        public RequestOptionsBuilder clearAtlanAccount() {
            return this.setAtlanAccount(null);
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiKey(this.apiKey), RequestOptions.normalizeClientId(this.clientId), RequestOptions.normalizeIdempotencyKey(this.idempotencyKey), RequestOptions.normalizeAtlanAccount(this.atlanAccount), this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.connectionProxy, this.proxyCredential);
        }
    }
}

