/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.cache.ClassificationCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.Classification;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public class ClassificationSerializer
extends StdSerializer<Classification> {
    private static final long serialVersionUID = 2L;

    public ClassificationSerializer() {
        this(null);
    }

    public ClassificationSerializer(Class<Classification> t) {
        super(t);
    }

    public void serializeWithType(Classification value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    public void serialize(Classification cls, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
        String clsId;
        String clsName = cls.getTypeName();
        try {
            clsId = ClassificationCache.getIdForName(clsName);
        }
        catch (AtlanException e) {
            throw new IOException("Unable to find classification with name: " + clsName, e);
        }
        gen.writeStartObject();
        JacksonUtils.serializeString(gen, "typeName", clsId);
        JacksonUtils.serializeString(gen, "entityGuid", cls.getEntityGuid());
        AtlanStatus status = cls.getEntityStatus();
        if (status != null) {
            JacksonUtils.serializeString(gen, "entityStatus", status.getValue());
        }
        JacksonUtils.serializeBoolean(gen, "propagate", cls.getPropagate());
        JacksonUtils.serializeBoolean(gen, "removePropagationsOnEntityDelete", cls.getRemovePropagationsOnEntityDelete());
        JacksonUtils.serializeBoolean(gen, "restrictPropagationThroughLineage", cls.getRestrictPropagationThroughLineage());
        gen.writeEndObject();
    }
}

