/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.cache.CustomMetadataCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.search.CustomMetadataAttributesAuditDetail;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;

public class CustomMetadataAuditDeserializer
extends StdDeserializer<CustomMetadataAttributesAuditDetail> {
    private static final long serialVersionUID = 2L;

    public CustomMetadataAuditDeserializer() {
        super(CustomMetadataAttributesAuditDetail.class);
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public CustomMetadataAttributesAuditDetail deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser));
    }

    CustomMetadataAttributesAuditDetail deserialize(JsonNode root) throws IOException {
        CustomMetadataAttributes cma;
        String cmName;
        String cmId = root.get("typeName").asText();
        if (cmId == null) {
            throw new IOException("Unable to deserialize custom metadata from: " + root);
        }
        try {
            cmName = CustomMetadataCache.getNameForId(cmId);
        }
        catch (AtlanException e) {
            throw new IOException("Unable to find custom metadata with ID-string: " + cmId, e);
        }
        JsonNode attributes = root.get("attributes");
        try {
            cma = CustomMetadataCache.getCustomMetadataAttributes(cmId, attributes);
        }
        catch (AtlanException e) {
            throw new IOException("Unable to translate custom metadata attributes: " + attributes, e);
        }
        return ((CustomMetadataAttributesAuditDetail.CustomMetadataAttributesAuditDetailBuilder)((CustomMetadataAttributesAuditDetail.CustomMetadataAttributesAuditDetailBuilder)((CustomMetadataAttributes.CustomMetadataAttributesBuilder)CustomMetadataAttributesAuditDetail.builder().typeName(cmName)).attributes(cma.getAttributes())).archivedAttributes(cma.getArchivedAttributes())).build();
    }
}

