/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.cache.ClassificationCache;
import com.atlan.cache.CustomMetadataCache;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.APIPath;
import com.atlan.model.assets.APISpec;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.AtlanCollection;
import com.atlan.model.assets.AtlanQuery;
import com.atlan.model.assets.BIProcess;
import com.atlan.model.assets.Badge;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.ColumnProcess;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.DataStudioAsset;
import com.atlan.model.assets.Database;
import com.atlan.model.assets.DbtColumnProcess;
import com.atlan.model.assets.DbtMetric;
import com.atlan.model.assets.DbtModel;
import com.atlan.model.assets.DbtModelColumn;
import com.atlan.model.assets.DbtProcess;
import com.atlan.model.assets.DbtSource;
import com.atlan.model.assets.Folder;
import com.atlan.model.assets.GCSBucket;
import com.atlan.model.assets.GCSObject;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.assets.Insight;
import com.atlan.model.assets.LineageProcess;
import com.atlan.model.assets.Link;
import com.atlan.model.assets.LookerDashboard;
import com.atlan.model.assets.LookerExplore;
import com.atlan.model.assets.LookerField;
import com.atlan.model.assets.LookerFolder;
import com.atlan.model.assets.LookerLook;
import com.atlan.model.assets.LookerModel;
import com.atlan.model.assets.LookerProject;
import com.atlan.model.assets.LookerQuery;
import com.atlan.model.assets.LookerTile;
import com.atlan.model.assets.LookerView;
import com.atlan.model.assets.MaterializedView;
import com.atlan.model.assets.MetabaseCollection;
import com.atlan.model.assets.MetabaseDashboard;
import com.atlan.model.assets.MetabaseQuestion;
import com.atlan.model.assets.ModeChart;
import com.atlan.model.assets.ModeCollection;
import com.atlan.model.assets.ModeQuery;
import com.atlan.model.assets.ModeReport;
import com.atlan.model.assets.ModeWorkspace;
import com.atlan.model.assets.PowerBIColumn;
import com.atlan.model.assets.PowerBIDashboard;
import com.atlan.model.assets.PowerBIDataflow;
import com.atlan.model.assets.PowerBIDataset;
import com.atlan.model.assets.PowerBIDatasource;
import com.atlan.model.assets.PowerBIMeasure;
import com.atlan.model.assets.PowerBIPage;
import com.atlan.model.assets.PowerBIReport;
import com.atlan.model.assets.PowerBITable;
import com.atlan.model.assets.PowerBITile;
import com.atlan.model.assets.PowerBIWorkspace;
import com.atlan.model.assets.PresetChart;
import com.atlan.model.assets.PresetDashboard;
import com.atlan.model.assets.PresetDataset;
import com.atlan.model.assets.PresetWorkspace;
import com.atlan.model.assets.Procedure;
import com.atlan.model.assets.Readme;
import com.atlan.model.assets.ReadmeTemplate;
import com.atlan.model.assets.S3Bucket;
import com.atlan.model.assets.S3Object;
import com.atlan.model.assets.SalesforceDashboard;
import com.atlan.model.assets.SalesforceField;
import com.atlan.model.assets.SalesforceObject;
import com.atlan.model.assets.SalesforceOrganization;
import com.atlan.model.assets.SalesforceReport;
import com.atlan.model.assets.Schema;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.TablePartition;
import com.atlan.model.assets.TableauCalculatedField;
import com.atlan.model.assets.TableauDashboard;
import com.atlan.model.assets.TableauDatasource;
import com.atlan.model.assets.TableauDatasourceField;
import com.atlan.model.assets.TableauFlow;
import com.atlan.model.assets.TableauMetric;
import com.atlan.model.assets.TableauProject;
import com.atlan.model.assets.TableauSite;
import com.atlan.model.assets.TableauWorkbook;
import com.atlan.model.assets.TableauWorksheet;
import com.atlan.model.assets.View;
import com.atlan.model.core.Classification;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.serde.Serde;
import com.atlan.util.JacksonUtils;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class EntityDeserializer
extends StdDeserializer<Entity> {
    private static final long serialVersionUID = 2L;

    public EntityDeserializer() {
        this(null);
    }

    public EntityDeserializer(Class<?> t) {
        super(t);
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public Entity deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser));
    }

    Entity deserialize(JsonNode root) throws IOException {
        Method method;
        Object deserializeName;
        Iterator itr;
        Set<String> pendingTasks;
        Set<String> meaningNames;
        Asset.AssetBuilder builder;
        JsonNode attributes = root.get("attributes");
        JsonNode relationshipGuid = root.get("relationshipGuid");
        JsonNode relationshipAttributes = root.get("relationshipAttributes");
        JsonNode businessAttributes = root.get("businessAttributes");
        JsonNode classificationNames = root.get("classificationNames");
        String typeName = root.get("typeName").asText();
        if (typeName == null) {
            builder = IndistinctAsset.builder();
        } else {
            switch (typeName) {
                case "APIPath": {
                    builder = APIPath.builder();
                    break;
                }
                case "APISpec": {
                    builder = APISpec.builder();
                    break;
                }
                case "Collection": {
                    builder = AtlanCollection.builder();
                    break;
                }
                case "Query": {
                    builder = AtlanQuery.builder();
                    break;
                }
                case "BIProcess": {
                    builder = BIProcess.builder();
                    break;
                }
                case "Badge": {
                    builder = Badge.builder();
                    break;
                }
                case "Column": {
                    builder = Column.builder();
                    break;
                }
                case "ColumnProcess": {
                    builder = ColumnProcess.builder();
                    break;
                }
                case "Connection": {
                    builder = Connection.builder();
                    break;
                }
                case "DataStudioAsset": {
                    builder = DataStudioAsset.builder();
                    break;
                }
                case "Database": {
                    builder = Database.builder();
                    break;
                }
                case "DbtColumnProcess": {
                    builder = DbtColumnProcess.builder();
                    break;
                }
                case "DbtMetric": {
                    builder = DbtMetric.builder();
                    break;
                }
                case "DbtModel": {
                    builder = DbtModel.builder();
                    break;
                }
                case "DbtModelColumn": {
                    builder = DbtModelColumn.builder();
                    break;
                }
                case "DbtProcess": {
                    builder = DbtProcess.builder();
                    break;
                }
                case "DbtSource": {
                    builder = DbtSource.builder();
                    break;
                }
                case "Folder": {
                    builder = Folder.builder();
                    break;
                }
                case "GCSBucket": {
                    builder = GCSBucket.builder();
                    break;
                }
                case "GCSObject": {
                    builder = GCSObject.builder();
                    break;
                }
                case "AtlasGlossary": {
                    builder = Glossary.builder();
                    break;
                }
                case "AtlasGlossaryCategory": {
                    builder = GlossaryCategory.builder();
                    break;
                }
                case "AtlasGlossaryTerm": {
                    builder = GlossaryTerm.builder();
                    break;
                }
                case "Insight": {
                    builder = Insight.builder();
                    break;
                }
                case "Process": {
                    builder = LineageProcess.builder();
                    break;
                }
                case "Link": {
                    builder = Link.builder();
                    break;
                }
                case "LookerDashboard": {
                    builder = LookerDashboard.builder();
                    break;
                }
                case "LookerExplore": {
                    builder = LookerExplore.builder();
                    break;
                }
                case "LookerField": {
                    builder = LookerField.builder();
                    break;
                }
                case "LookerFolder": {
                    builder = LookerFolder.builder();
                    break;
                }
                case "LookerLook": {
                    builder = LookerLook.builder();
                    break;
                }
                case "LookerModel": {
                    builder = LookerModel.builder();
                    break;
                }
                case "LookerProject": {
                    builder = LookerProject.builder();
                    break;
                }
                case "LookerQuery": {
                    builder = LookerQuery.builder();
                    break;
                }
                case "LookerTile": {
                    builder = LookerTile.builder();
                    break;
                }
                case "LookerView": {
                    builder = LookerView.builder();
                    break;
                }
                case "MaterialisedView": {
                    builder = MaterializedView.builder();
                    break;
                }
                case "MetabaseCollection": {
                    builder = MetabaseCollection.builder();
                    break;
                }
                case "MetabaseDashboard": {
                    builder = MetabaseDashboard.builder();
                    break;
                }
                case "MetabaseQuestion": {
                    builder = MetabaseQuestion.builder();
                    break;
                }
                case "ModeChart": {
                    builder = ModeChart.builder();
                    break;
                }
                case "ModeCollection": {
                    builder = ModeCollection.builder();
                    break;
                }
                case "ModeQuery": {
                    builder = ModeQuery.builder();
                    break;
                }
                case "ModeReport": {
                    builder = ModeReport.builder();
                    break;
                }
                case "ModeWorkspace": {
                    builder = ModeWorkspace.builder();
                    break;
                }
                case "PowerBIColumn": {
                    builder = PowerBIColumn.builder();
                    break;
                }
                case "PowerBIDashboard": {
                    builder = PowerBIDashboard.builder();
                    break;
                }
                case "PowerBIDataflow": {
                    builder = PowerBIDataflow.builder();
                    break;
                }
                case "PowerBIDataset": {
                    builder = PowerBIDataset.builder();
                    break;
                }
                case "PowerBIDatasource": {
                    builder = PowerBIDatasource.builder();
                    break;
                }
                case "PowerBIMeasure": {
                    builder = PowerBIMeasure.builder();
                    break;
                }
                case "PowerBIPage": {
                    builder = PowerBIPage.builder();
                    break;
                }
                case "PowerBIReport": {
                    builder = PowerBIReport.builder();
                    break;
                }
                case "PowerBITable": {
                    builder = PowerBITable.builder();
                    break;
                }
                case "PowerBITile": {
                    builder = PowerBITile.builder();
                    break;
                }
                case "PowerBIWorkspace": {
                    builder = PowerBIWorkspace.builder();
                    break;
                }
                case "PresetChart": {
                    builder = PresetChart.builder();
                    break;
                }
                case "PresetDashboard": {
                    builder = PresetDashboard.builder();
                    break;
                }
                case "PresetDataset": {
                    builder = PresetDataset.builder();
                    break;
                }
                case "PresetWorkspace": {
                    builder = PresetWorkspace.builder();
                    break;
                }
                case "Procedure": {
                    builder = Procedure.builder();
                    break;
                }
                case "Readme": {
                    builder = Readme.builder();
                    break;
                }
                case "ReadmeTemplate": {
                    builder = ReadmeTemplate.builder();
                    break;
                }
                case "S3Bucket": {
                    builder = S3Bucket.builder();
                    break;
                }
                case "S3Object": {
                    builder = S3Object.builder();
                    break;
                }
                case "SalesforceDashboard": {
                    builder = SalesforceDashboard.builder();
                    break;
                }
                case "SalesforceField": {
                    builder = SalesforceField.builder();
                    break;
                }
                case "SalesforceObject": {
                    builder = SalesforceObject.builder();
                    break;
                }
                case "SalesforceOrganization": {
                    builder = SalesforceOrganization.builder();
                    break;
                }
                case "SalesforceReport": {
                    builder = SalesforceReport.builder();
                    break;
                }
                case "Schema": {
                    builder = Schema.builder();
                    break;
                }
                case "Table": {
                    builder = Table.builder();
                    break;
                }
                case "TablePartition": {
                    builder = TablePartition.builder();
                    break;
                }
                case "TableauCalculatedField": {
                    builder = TableauCalculatedField.builder();
                    break;
                }
                case "TableauDashboard": {
                    builder = TableauDashboard.builder();
                    break;
                }
                case "TableauDatasource": {
                    builder = TableauDatasource.builder();
                    break;
                }
                case "TableauDatasourceField": {
                    builder = TableauDatasourceField.builder();
                    break;
                }
                case "TableauFlow": {
                    builder = TableauFlow.builder();
                    break;
                }
                case "TableauMetric": {
                    builder = TableauMetric.builder();
                    break;
                }
                case "TableauProject": {
                    builder = TableauProject.builder();
                    break;
                }
                case "TableauSite": {
                    builder = TableauSite.builder();
                    break;
                }
                case "TableauWorkbook": {
                    builder = TableauWorkbook.builder();
                    break;
                }
                case "TableauWorksheet": {
                    builder = TableauWorksheet.builder();
                    break;
                }
                case "View": {
                    builder = View.builder();
                    break;
                }
                default: {
                    builder = IndistinctAsset.builder();
                }
            }
        }
        builder = ((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Entity.EntityBuilder)((Reference.ReferenceBuilder)builder).typeName(JacksonUtils.deserializeString(root, "typeName"))).guid(JacksonUtils.deserializeString(root, "guid"))).displayText(JacksonUtils.deserializeString(root, "displayText"))).entityStatus(JacksonUtils.deserializeString(root, "entityStatus"))).relationshipType(JacksonUtils.deserializeString(root, "relationshipType"))).relationshipGuid(JacksonUtils.deserializeString(root, "relationshipGuid"))).relationshipStatus(JacksonUtils.deserializeObject(root, "relationshipStatus", new TypeReference<AtlanStatus>(){}))).uniqueAttributes(JacksonUtils.deserializeObject(root, "uniqueAttributes", new TypeReference<UniqueAttributes>(){}))).status(JacksonUtils.deserializeObject(root, "status", new TypeReference<AtlanStatus>(){}))).createdBy(JacksonUtils.deserializeString(root, "createdBy"))).updatedBy(JacksonUtils.deserializeString(root, "updatedBy"))).createTime(JacksonUtils.deserializeLong(root, "createTime"))).updateTime(JacksonUtils.deserializeLong(root, "updateTime"))).deleteHandler(JacksonUtils.deserializeString(root, "deleteHandler"))).isIncomplete(JacksonUtils.deserializeBoolean(root, "isIncomplete"));
        Set<Classification> classifications = JacksonUtils.deserializeObject(root, "classifications", new TypeReference<Set<Classification>>(){});
        if (classifications != null) {
            builder = builder.classifications(classifications);
        }
        if ((meaningNames = JacksonUtils.deserializeObject(root, "meaningNames", new TypeReference<Set<String>>(){})) != null) {
            builder = builder.meaningNames(meaningNames);
        }
        if ((pendingTasks = JacksonUtils.deserializeObject(root, "pendingTasks", new TypeReference<Set<String>>(){})) != null) {
            builder = builder.pendingTasks(pendingTasks);
        }
        Reference value = ((Entity.EntityBuilder)builder).build();
        Class<?> clazz = value.getClass();
        HashMap<String, JsonNode> leftOverAttributes = new HashMap<String, JsonNode>();
        if (attributes != null && !attributes.isNull()) {
            itr = attributes.fieldNames();
            while (itr.hasNext()) {
                String attrKey = (String)itr.next();
                deserializeName = ReflectionCache.getDeserializedName(clazz, attrKey);
                method = ReflectionCache.getSetter(clazz, (String)deserializeName);
                if (method != null) {
                    try {
                        this.deserialize((Entity)value, attributes.get(attrKey), method, (String)deserializeName);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        throw new IOException("Missing fromValue method for enum.", e);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IOException("Failed to deserialize through reflection.", e);
                    }
                }
                leftOverAttributes.put(attrKey, attributes.get(attrKey));
            }
        }
        if ((relationshipGuid == null || relationshipGuid.isNull()) && relationshipAttributes != null && !relationshipAttributes.isNull()) {
            itr = relationshipAttributes.fieldNames();
            while (itr.hasNext()) {
                String relnKey = (String)itr.next();
                deserializeName = ReflectionCache.getDeserializedName(clazz, relnKey);
                method = ReflectionCache.getSetter(clazz, (String)deserializeName);
                if (method == null) continue;
                try {
                    this.deserialize((Entity)value, relationshipAttributes.get(relnKey), method, (String)deserializeName);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Missing fromValue method for enum.", e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IOException("Failed to deserialize through reflection.", e);
                }
            }
        }
        Map<String, CustomMetadataAttributes> cm = null;
        if (!leftOverAttributes.isEmpty()) {
            try {
                cm = CustomMetadataCache.getCustomMetadataFromSearchResult(leftOverAttributes);
            }
            catch (AtlanException e) {
                e.printStackTrace();
                throw new IOException("Unable to deserialize custom metadata from search result.", e);
            }
        }
        if (businessAttributes != null) {
            try {
                cm = CustomMetadataCache.getCustomMetadataFromBusinessAttributes(businessAttributes);
            }
            catch (AtlanException e) {
                e.printStackTrace();
                throw new IOException("Unable to deserialize custom metadata.", e);
            }
        }
        HashSet<String> clsNames = null;
        if (classificationNames != null && classificationNames.isArray()) {
            clsNames = new HashSet<String>();
            try {
                for (JsonNode element : classificationNames) {
                    String name = ClassificationCache.getNameForId(element.asText());
                    clsNames.add(name);
                }
            }
            catch (AtlanException e) {
                throw new IOException("Unable to deserialize classification name.", e);
            }
        }
        if (typeName != null && typeName.equals("Readme")) {
            Readme readme = (Readme)value;
            readme.setDescription(StringUtils.decodeContent(readme.getDescription()));
        }
        ((Entity)value).setCustomMetadataSets(cm);
        ((Entity)value).setClassificationNames(clsNames);
        return value;
    }

    private void deserialize(Entity value, JsonNode jsonNode, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (jsonNode.isValueNode()) {
            this.deserializePrimitive(value, jsonNode, method, fieldName);
        } else if (jsonNode.isArray()) {
            this.deserializeList(value, (ArrayNode)jsonNode, method);
        } else if (jsonNode.isObject()) {
            this.deserializeObject(value, jsonNode, method);
        }
    }

    private void deserializeList(Entity value, ArrayNode array, Method method) throws IllegalAccessException, InvocationTargetException, IOException {
        Class<?> paramClass = ReflectionCache.getParameterOfMethod(method);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonNode element : array) {
            Object deserialized = this.deserializeElement(element, method);
            list.add(deserialized);
        }
        if (paramClass == List.class) {
            method.invoke((Object)value, list);
        } else if (paramClass == Set.class || paramClass == SortedSet.class) {
            method.invoke((Object)value, new TreeSet(list));
        } else {
            throw new IOException("Unable to deserialize JSON list to Java class: " + paramClass.getCanonicalName());
        }
    }

    private void deserializeObject(Entity value, JsonNode jsonObject, Method method) throws IllegalAccessException, InvocationTargetException, IOException {
        Class<?> paramClass = ReflectionCache.getParameterOfMethod(method);
        method.invoke((Object)value, Serde.mapper.readValue(jsonObject.toString(), paramClass));
    }

    private Object deserializeElement(JsonNode element, Method method) throws IOException {
        if (element.isValueNode()) {
            return JacksonUtils.deserializePrimitive(element, method);
        }
        if (element.isArray()) {
            throw new IOException("Directly-nested arrays are not supported.");
        }
        if (element.isObject()) {
            Type paramType = ReflectionCache.getParameterizedTypeOfMethod(method);
            Class<?> innerClass = ReflectionCache.getClassOfParameterizedType(paramType);
            return Serde.mapper.readValue(element.toString(), innerClass);
        }
        return null;
    }

    private void deserializePrimitive(Entity value, JsonNode primitive, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (primitive.isTextual()) {
            Class<?> paramClass = ReflectionCache.getParameterOfMethod(method);
            if (paramClass.isEnum()) {
                Method fromValue = paramClass.getMethod("fromValue", String.class);
                method.invoke((Object)value, fromValue.invoke(null, primitive.asText()));
            } else {
                method.invoke((Object)value, primitive.asText());
            }
        } else if (primitive.isBoolean()) {
            method.invoke((Object)value, primitive.asBoolean());
        } else if (primitive.isNumber()) {
            this.deserializeNumber(value, primitive, method);
        } else if (primitive.isNull()) {
            value.addNullField(fieldName);
        }
    }

    private void deserializeNumber(Entity value, JsonNode primitive, Method method) throws IllegalAccessException, InvocationTargetException, IOException {
        Object number = JacksonUtils.deserializeNumber(primitive, method);
        method.invoke((Object)value, number);
    }
}

