/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.cache.CustomMetadataCache;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.core.Entity;
import com.atlan.serde.Removable;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializer
extends StdSerializer<Entity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntitySerializer.class);
    private static final long serialVersionUID = 2L;

    public EntitySerializer() {
        this(null);
    }

    public EntitySerializer(Class<Entity> t) {
        super(t);
    }

    public void serializeWithType(Entity value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    public void serialize(Entity entity, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
        Class<?> clazz = entity.getClass();
        Set<String> nullFields = entity.getNullFields();
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> businessAttributes = new LinkedHashMap<String, Map<String, Object>>();
        gen.writeStartObject();
        try {
            for (String fieldName : ReflectionCache.getFieldNames(clazz)) {
                String serializeName;
                Object attrValue;
                if (ReflectionCache.isAttribute(clazz, fieldName)) {
                    Class<?> type;
                    attrValue = nullFields.contains(fieldName) ? ((type = ReflectionCache.getFieldType(clazz, fieldName)) == List.class || type == Set.class || type == SortedSet.class ? Removable.EMPTY_LIST : Removable.NULL) : ReflectionCache.getGetter(clazz, fieldName).invoke((Object)entity, new Object[0]);
                    if (attrValue == null) continue;
                    serializeName = ReflectionCache.getSerializedName(clazz, fieldName);
                    attributes.put(serializeName, attrValue);
                    continue;
                }
                if (fieldName.equals("customMetadataSets")) {
                    Map<String, CustomMetadataAttributes> cm = entity.getCustomMetadataSets();
                    if (cm != null) {
                        CustomMetadataCache.getBusinessAttributesFromCustomMetadata(cm, businessAttributes);
                    }
                    entity.setCustomMetadataSets(null);
                    continue;
                }
                attrValue = ReflectionCache.getGetter(clazz, fieldName).invoke((Object)entity, new Object[0]);
                if (attrValue == null || attrValue instanceof Collection && ((Collection)attrValue).isEmpty()) continue;
                serializeName = ReflectionCache.getSerializedName(clazz, fieldName);
                sp.defaultSerializeField(serializeName, attrValue, gen);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException("Unable to retrieve value through reflection.", e);
        }
        catch (AtlanException e) {
            throw new IOException("Unable to retrieve the available custom metadata in Atlan.", e);
        }
        if (!attributes.isEmpty()) {
            sp.defaultSerializeField("attributes", attributes, gen);
        }
        if (!businessAttributes.isEmpty()) {
            sp.defaultSerializeField("businessAttributes", businessAttributes, gen);
        }
        gen.writeEndObject();
    }
}

