/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import com.atlan.serde.ElasticAggregationDeserializer;
import com.atlan.serde.ElasticObjectSerializer;
import com.atlan.serde.ElasticQueryDeserializer;
import com.atlan.serde.ElasticSortOptionsDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.LinkedHashSet;
import java.util.Set;

public class Serde {
    private static final Set<Module> modules = Serde.createModules();
    public static final ObjectMapper mapper = Serde.createMapper();
    public static final ObjectMapper allInclusiveMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS);
    static final JsonpMapper jsonpMapper = new JacksonJsonpMapper();

    private static Set<Module> createModules() {
        LinkedHashSet<Module> set = new LinkedHashSet<Module>();
        SimpleModule elastic = new SimpleModule().addSerializer(Aggregation.class, new ElasticObjectSerializer()).addDeserializer(Aggregation.class, (JsonDeserializer)new ElasticAggregationDeserializer()).addSerializer(Query.class, new ElasticObjectSerializer()).addDeserializer(Query.class, (JsonDeserializer)new ElasticQueryDeserializer()).addSerializer(SortOptions.class, new ElasticObjectSerializer()).addDeserializer(SortOptions.class, (JsonDeserializer)new ElasticSortOptionsDeserializer());
        set.add((Module)elastic);
        return set;
    }

    private static ObjectMapper createMapper() {
        ObjectMapper om = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (Module m : modules) {
            om.registerModule(m);
        }
        return om;
    }
}

