/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class JacksonUtils {
    public static Object deserializePrimitive(JsonNode primitive, Method method) throws IOException {
        if (primitive.isTextual()) {
            return primitive.asText();
        }
        if (primitive.isBoolean()) {
            return primitive.asBoolean();
        }
        if (primitive.isNumber()) {
            return JacksonUtils.deserializeNumber(primitive, method);
        }
        return null;
    }

    public static Object deserializeNumber(JsonNode primitive, Method method) throws IOException {
        Parameter[] parameters = method.getParameters();
        if (parameters.length != 1) {
            throw new IOException("Unexpected number of parameters (" + parameters.length + ") found for method: " + method);
        }
        Class<?> parameterType = parameters[0].getType();
        if (parameterType == Integer.class) {
            return primitive.asInt();
        }
        if (parameterType == Long.class) {
            return primitive.asLong();
        }
        if (parameterType == Double.class) {
            return primitive.asDouble();
        }
        if (parameterType == Float.class) {
            return Float.valueOf(primitive.floatValue());
        }
        if (parameterType == Short.class) {
            return primitive.shortValue();
        }
        throw new IOException("Unhandled parameter type (" + parameterType + ") found for method: " + method);
    }

    public static String deserializeString(JsonNode node, String path) {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : value.asText();
    }

    public static void serializeString(JsonGenerator gen, String name, String value) throws IOException {
        if (value != null) {
            gen.writeFieldName(name);
            gen.writeString(value);
        }
    }

    public static Long deserializeLong(JsonNode node, String path) {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : Long.valueOf(value.asLong());
    }

    public static Boolean deserializeBoolean(JsonNode node, String path) {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : Boolean.valueOf(value.asBoolean());
    }

    public static void serializeBoolean(JsonGenerator gen, String name, Boolean value) throws IOException {
        if (value != null) {
            gen.writeFieldName(name);
            gen.writeBoolean(value.booleanValue());
        }
    }

    public static <T> T deserializeObject(JsonNode node, String path, TypeReference<T> typeReference) throws JsonProcessingException {
        JsonNode value = node.get(path);
        return (T)(value == null || value.isNull() ? null : Serde.mapper.readValue(value.toString(), typeReference));
    }
}

