/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ExistsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import com.atlan.cache.ClassificationCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanStatus;
import java.util.ArrayList;
import java.util.List;

public class QueryFactory {
    private static final Query ACTIVE = TermQuery.of(t -> t.field("__state").value(AtlanStatus.ACTIVE.getValue()))._toQuery();
    private static final Query ARCHIVED = TermQuery.of(t -> t.field("__state").value(AtlanStatus.DELETED.getValue()))._toQuery();
    private static final Query WITH_LINEAGE = TermQuery.of(t -> t.field("__hasLineage").value(true))._toQuery();

    public static Query active() {
        return ACTIVE;
    }

    public static Query archived() {
        return ARCHIVED;
    }

    public static Query withLineage() {
        return WITH_LINEAGE;
    }

    public static Query withType(String typeName) {
        return TermQuery.of(t -> t.field("__typeName.keyword").value(typeName))._toQuery();
    }

    public static Query withSuperType(String typeName) {
        return TermQuery.of(t -> t.field("__superTypeNames.keyword").value(typeName))._toQuery();
    }

    public static Query withCertificate(AtlanCertificateStatus certificate) {
        return TermQuery.of(t -> t.field("certificateStatus").value(certificate.getValue()))._toQuery();
    }

    public static Query withExactName(String name) {
        return TermQuery.of(t -> t.field("name.keyword").value(name))._toQuery();
    }

    public static Query whereQualifiedNameStartsWith(String qualifiedName) {
        return PrefixQuery.of(t -> t.field("qualifiedName").value(qualifiedName))._toQuery();
    }

    public static Query withAnyValueFor(String attribute) {
        return ExistsQuery.of(t -> t.field(attribute))._toQuery();
    }

    public static Query withAtLeastOneClassification(List<String> classificationNames) throws AtlanException {
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        for (String name : classificationNames) {
            String classificationId = ClassificationCache.getIdForName(name);
            if (classificationId == null) {
                throw new InvalidRequestException("Unable to find classification with name: " + name, "classificationName", "ATLAN-JAVA-CLIENT-400-200", 400, null);
            }
            values.add(FieldValue.of((String)classificationId));
        }
        Query byDirectClassification = TermsQuery.of(t -> t.field("__traitNames").terms(TermsQueryField.of(f -> f.value(values))))._toQuery();
        Query byPropagatedClassification = TermsQuery.of(t -> t.field("__propagatedTraitNames").terms(TermsQueryField.of(f -> f.value(values))))._toQuery();
        return BoolQuery.of(b -> b.should(byDirectClassification, new Query[]{byPropagatedClassification}).minimumShouldMatch("1"))._toQuery();
    }

    public static Query withAtLeastOneTerm(List<String> termQualifiedNames) {
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        for (String qualifiedName : termQualifiedNames) {
            values.add(FieldValue.of((String)qualifiedName));
        }
        return TermsQuery.of(t -> t.field("__meanings").terms(TermsQueryField.of(f -> f.value(values))))._toQuery();
    }
}

