/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.regex.Pattern;

public final class StringUtils {
    private static Pattern whitespacePattern = Pattern.compile("\\s");

    public static boolean containsWhitespace(String str) {
        Objects.requireNonNull(str);
        return whitespacePattern.matcher(str).find();
    }

    public static boolean secureCompare(String a, String b) {
        byte[] digesta = a.getBytes(StandardCharsets.UTF_8);
        byte[] digestb = b.getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(digesta, digestb);
    }

    public static String getFieldNameFromMethodName(String methodName) {
        if (methodName.startsWith("set") || methodName.startsWith("get")) {
            StringBuilder sb = new StringBuilder(methodName);
            sb.delete(0, 3);
            sb.replace(0, 1, sb.substring(0, 1).toLowerCase());
            return sb.toString();
        }
        return null;
    }

    public static String encodeContent(String decoded) {
        return decoded == null ? null : URLEncoder.encode(decoded, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static String decodeContent(String encoded) {
        return encoded == null ? null : URLDecoder.decode(encoded.replace("%20", "+"), StandardCharsets.UTF_8);
    }

    public static String getNameFromQualifiedName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.indexOf("/") > 0) {
            return qualifiedName.substring(qualifiedName.lastIndexOf("/") + 1);
        }
        return null;
    }

    public static String getParentQualifiedNameFromQualifiedName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.indexOf("/") > 0) {
            return qualifiedName.substring(0, qualifiedName.lastIndexOf("/"));
        }
        return null;
    }
}

