/*
 * Decompiled with CFR 0.152.
 */
package com.authkit;

import com.authkit.AuthkitException;
import com.authkit.AuthorizeParameters;
import com.authkit.Config;
import com.authkit.FetchTokensParameters;
import com.authkit.StatelessAuthorizer;
import com.authkit.Tokens;
import com.authkit.Util;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class DefaultStatelessAuthorizer
implements StatelessAuthorizer {
    private final String authorizeEndpoint;
    private final String tokenEndpoint;
    private static final String ISSUER = "http://localhost:9996";
    private final HttpClient client;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public DefaultStatelessAuthorizer(Config config) {
        String issuer = config.getIssuer();
        this.authorizeEndpoint = issuer + "/authorize";
        this.tokenEndpoint = issuer + "/oauth/token";
        this.client = HttpClient.create();
    }

    @Override
    public Mono<String> buildAuthorizeUrl(AuthorizeParameters params) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.authorizeEndpoint);
        sb.append("?response_type=code&client_id=");
        sb.append(this.requireURLEncoded(params.getClientId(), "clientId"));
        sb.append("&redirect_uri=");
        sb.append(this.requireURLEncoded(params.getRedirectUri(), "redirectUri"));
        if (params.getScope() != null) {
            sb.append("&scope=");
            sb.append(this.urlEncode(String.join((CharSequence)" ", params.getScope())));
        }
        if (params.getNonce() != null) {
            sb.append("&nonce=");
            sb.append(this.urlEncode(params.getNonce()));
        }
        if (params.getCodeChallenge() != null) {
            sb.append("&code_challenge=");
            sb.append(this.urlEncode(params.getCodeChallenge()));
            sb.append("&code_challenge_method=");
            sb.append(this.requireURLEncoded(params.getCodeChallengeMethod(), "codeChallengeMethod"));
        }
        if (params.getPrompt() != null) {
            sb.append("&prompt=");
            sb.append(this.urlEncode(params.getPrompt()));
        }
        return Mono.just((Object)sb.toString());
    }

    @Override
    public Mono<Tokens> fetchTokens(FetchTokensParameters params) {
        return ((HttpClient.RequestSender)this.client.post().uri(this.tokenEndpoint)).sendForm((r, f) -> {
            f.attr("client_id", params.getClientId()).attr("grant_type", "authorization_code").attr("code", params.getCode()).attr("redirect_uri", params.getRedirectUri());
            if (params.getCodeVerifier() != null) {
                f.attr("code_verifier", params.getCodeVerifier());
            }
            if (params.getClientSecret() != null) {
                f.attr("client_secret", params.getClientSecret());
            }
        }).responseSingle((r, b) -> {
            if (r.status().code() == 200) {
                return b.asInputStream();
            }
            throw new AuthkitException("Unable to get token from server");
        }).map(i -> {
            try {
                Tokens tokens = (Tokens)GSON.fromJson((Reader)new InputStreamReader((InputStream)i), Tokens.class);
                return tokens;
            }
            finally {
                Util.close(i);
            }
        });
    }

    private String requireURLEncoded(String input, String label) {
        return this.urlEncode(Objects.requireNonNull(input, label));
    }

    private String urlEncode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }
}

