/**
 * Copyright 2013 Huining (Thomas) Feng (tfeng@berkeley.edu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.bacoder.parser.java.adapter;

import com.bacoder.parser.core.Adapters;
import com.bacoder.parser.java.JavaParser;
import com.bacoder.parser.java.JavaParser.ImportDeclarationContext;
import com.bacoder.parser.java.JavaParser.QualifiedNameContext;
import com.bacoder.parser.java.api.ImportDeclaration;

public class ImportDeclarationAdapter
    extends JavaAdapter<ImportDeclarationContext, ImportDeclaration> {

  public ImportDeclarationAdapter(Adapters adapters) {
    super(adapters);
  }

  @Override
  public ImportDeclaration adapt(ImportDeclarationContext context) {
    ImportDeclaration importDeclaration = createNode(context);
    importDeclaration.setStatic(hasTerminalNode(context, JavaParser.STATIC));
    importDeclaration.setAsterisk(hasTerminalNode(context, JavaParser.MUL));

    QualifiedNameContext qualifiedNameContext = getChild(context, QualifiedNameContext.class);
    if (qualifiedNameContext != null) {
      importDeclaration.setQualifiedName(
          getAdapter(QualifiedNameAdapter.class).adapt(qualifiedNameContext));
    }

    return importDeclaration;
  }
}
