/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.model.params;

import com.basicex.sdk.model.params.constant.ChainNetwork;

public class InvoiceUpdateParams {
    private String currency;
    private ChainNetwork chain;
    private String payerEmail;
    private Boolean ignoreParameterFailed;
    private String redirectUrl;

    public void checkParams() {
    }

    InvoiceUpdateParams(String currency, ChainNetwork chain, String payerEmail, Boolean ignoreParameterFailed, String redirectUrl) {
        this.currency = currency;
        this.chain = chain;
        this.payerEmail = payerEmail;
        this.ignoreParameterFailed = ignoreParameterFailed;
        this.redirectUrl = redirectUrl;
    }

    public static InvoiceUpdateParamsBuilder builder() {
        return new InvoiceUpdateParamsBuilder();
    }

    public InvoiceUpdateParamsBuilder toBuilder() {
        return new InvoiceUpdateParamsBuilder().currency(this.currency).chain(this.chain).payerEmail(this.payerEmail).ignoreParameterFailed(this.ignoreParameterFailed).redirectUrl(this.redirectUrl);
    }

    public String getCurrency() {
        return this.currency;
    }

    public ChainNetwork getChain() {
        return this.chain;
    }

    public String getPayerEmail() {
        return this.payerEmail;
    }

    public Boolean getIgnoreParameterFailed() {
        return this.ignoreParameterFailed;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public static class InvoiceUpdateParamsBuilder {
        private String currency;
        private ChainNetwork chain;
        private String payerEmail;
        private Boolean ignoreParameterFailed;
        private String redirectUrl;

        InvoiceUpdateParamsBuilder() {
        }

        public InvoiceUpdateParamsBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public InvoiceUpdateParamsBuilder chain(ChainNetwork chain) {
            this.chain = chain;
            return this;
        }

        public InvoiceUpdateParamsBuilder payerEmail(String payerEmail) {
            this.payerEmail = payerEmail;
            return this;
        }

        public InvoiceUpdateParamsBuilder ignoreParameterFailed(Boolean ignoreParameterFailed) {
            this.ignoreParameterFailed = ignoreParameterFailed;
            return this;
        }

        public InvoiceUpdateParamsBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public InvoiceUpdateParams build() {
            return new InvoiceUpdateParams(this.currency, this.chain, this.payerEmail, this.ignoreParameterFailed, this.redirectUrl);
        }

        public String toString() {
            return "InvoiceUpdateParams.InvoiceUpdateParamsBuilder(currency=" + this.currency + ", chain=" + (Object)((Object)this.chain) + ", payerEmail=" + this.payerEmail + ", ignoreParameterFailed=" + this.ignoreParameterFailed + ", redirectUrl=" + this.redirectUrl + ")";
        }
    }
}

