/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.model.params;

import com.basicex.sdk.util.Preconditions;
import com.basicex.sdk.util.StringUtils;
import java.math.BigDecimal;

public class RefundCreateParams {
    private BigDecimal amount;
    private Integer coinPrecision;
    private String amountType;
    private String merOrderNo;
    private String orderNo;
    private String merRefundOrderNo;
    private String refundReason;
    private String tradeStartTime;
    private String customerEmail;

    public void checkParams() {
        Preconditions.checkArgument(this.amount != null, "amount is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.amountType), "amountType is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.merOrderNo) && StringUtils.isNotEmpty(this.orderNo), "Merchant Order Number System order number cannot be empty at the same time");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.merRefundOrderNo), "merRefundOrderNo is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.refundReason), "refundReason is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.tradeStartTime), "tradeStartTime is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.customerEmail), "customerEmail is required");
    }

    RefundCreateParams(BigDecimal amount, Integer coinPrecision, String amountType, String merOrderNo, String orderNo, String merRefundOrderNo, String refundReason, String tradeStartTime, String customerEmail) {
        this.amount = amount;
        this.coinPrecision = coinPrecision;
        this.amountType = amountType;
        this.merOrderNo = merOrderNo;
        this.orderNo = orderNo;
        this.merRefundOrderNo = merRefundOrderNo;
        this.refundReason = refundReason;
        this.tradeStartTime = tradeStartTime;
        this.customerEmail = customerEmail;
    }

    public static RefundCreateParamsBuilder builder() {
        return new RefundCreateParamsBuilder();
    }

    public RefundCreateParamsBuilder toBuilder() {
        return new RefundCreateParamsBuilder().amount(this.amount).coinPrecision(this.coinPrecision).amountType(this.amountType).merOrderNo(this.merOrderNo).orderNo(this.orderNo).merRefundOrderNo(this.merRefundOrderNo).refundReason(this.refundReason).tradeStartTime(this.tradeStartTime).customerEmail(this.customerEmail);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Integer getCoinPrecision() {
        return this.coinPrecision;
    }

    public String getAmountType() {
        return this.amountType;
    }

    public String getMerOrderNo() {
        return this.merOrderNo;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getMerRefundOrderNo() {
        return this.merRefundOrderNo;
    }

    public String getRefundReason() {
        return this.refundReason;
    }

    public String getTradeStartTime() {
        return this.tradeStartTime;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public static class RefundCreateParamsBuilder {
        private BigDecimal amount;
        private Integer coinPrecision;
        private String amountType;
        private String merOrderNo;
        private String orderNo;
        private String merRefundOrderNo;
        private String refundReason;
        private String tradeStartTime;
        private String customerEmail;

        RefundCreateParamsBuilder() {
        }

        public RefundCreateParamsBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public RefundCreateParamsBuilder coinPrecision(Integer coinPrecision) {
            this.coinPrecision = coinPrecision;
            return this;
        }

        public RefundCreateParamsBuilder amountType(String amountType) {
            this.amountType = amountType;
            return this;
        }

        public RefundCreateParamsBuilder merOrderNo(String merOrderNo) {
            this.merOrderNo = merOrderNo;
            return this;
        }

        public RefundCreateParamsBuilder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public RefundCreateParamsBuilder merRefundOrderNo(String merRefundOrderNo) {
            this.merRefundOrderNo = merRefundOrderNo;
            return this;
        }

        public RefundCreateParamsBuilder refundReason(String refundReason) {
            this.refundReason = refundReason;
            return this;
        }

        public RefundCreateParamsBuilder tradeStartTime(String tradeStartTime) {
            this.tradeStartTime = tradeStartTime;
            return this;
        }

        public RefundCreateParamsBuilder customerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
            return this;
        }

        public RefundCreateParams build() {
            return new RefundCreateParams(this.amount, this.coinPrecision, this.amountType, this.merOrderNo, this.orderNo, this.merRefundOrderNo, this.refundReason, this.tradeStartTime, this.customerEmail);
        }

        public String toString() {
            return "RefundCreateParams.RefundCreateParamsBuilder(amount=" + this.amount + ", coinPrecision=" + this.coinPrecision + ", amountType=" + this.amountType + ", merOrderNo=" + this.merOrderNo + ", orderNo=" + this.orderNo + ", merRefundOrderNo=" + this.merRefundOrderNo + ", refundReason=" + this.refundReason + ", tradeStartTime=" + this.tradeStartTime + ", customerEmail=" + this.customerEmail + ")";
        }
    }
}

