/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.net;

import com.basicex.sdk.exception.ApiConnectionException;
import com.basicex.sdk.exception.AuthenticationException;
import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.net.ApiResource;
import com.basicex.sdk.net.HttpContent;
import com.basicex.sdk.net.HttpHeaders;
import com.basicex.sdk.net.RequestOptions;
import com.basicex.sdk.util.X509CertificateUtils;
import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class BasicexRequest {
    private ApiResource.RequestMethod method;
    private URL url;
    private HttpContent content;
    private HttpHeaders headers;
    private Object params;
    private RequestOptions options;

    public BasicexRequest(ApiResource.RequestMethod method, String url, Object params, RequestOptions options) throws BasicexException {
        try {
            this.params = params;
            this.options = options;
            this.method = method;
            this.url = new URL(url);
            this.content = BasicexRequest.buildContent(method, params);
            this.headers = BasicexRequest.buildHeaders(method, this.options);
        }
        catch (IOException e) {
            throw new ApiConnectionException(String.format("IOException during API request to BasicEx (%s): %s ", options.getApiBaseUrl(), e.getMessage()), e);
        }
        catch (CertificateException e) {
            throw new AuthenticationException(String.format("CertificateException during API request to BasicEx (%s): %s ", options.getApiBaseUrl(), e.getMessage()), null, null, null, e);
        }
    }

    private static HttpContent buildContent(ApiResource.RequestMethod method, Object params) throws IOException {
        if (method != ApiResource.RequestMethod.POST && method != ApiResource.RequestMethod.PUT) {
            return null;
        }
        return HttpContent.buildApplicationJsonContent(params);
    }

    private static HttpHeaders buildHeaders(ApiResource.RequestMethod method, RequestOptions options) throws IOException, AuthenticationException, CertificateException {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Accept", Collections.singletonList("application/json"));
        headerMap.put("Accept-Charset", Collections.singletonList(ApiResource.CHARSET.name()));
        X509Certificate certificate = options.getCertificate();
        if (certificate == null) {
            throw new AuthenticationException("No Merchant certificate provided.", null, null, 0);
        }
        headerMap.put("X-Identity", Collections.singletonList(X509CertificateUtils.toPEMString(certificate).replaceAll("\r\n", "")));
        return HttpHeaders.of(headerMap);
    }

    public ApiResource.RequestMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getParams() {
        return this.params;
    }

    public RequestOptions getOptions() {
        return this.options;
    }

    public void setMethod(ApiResource.RequestMethod method) {
        this.method = method;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setContent(HttpContent content) {
        this.content = content;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public void setOptions(RequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicexRequest)) {
            return false;
        }
        BasicexRequest other = (BasicexRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiResource.RequestMethod this$method = this.getMethod();
        ApiResource.RequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        HttpContent this$content = this.getContent();
        HttpContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Object this$params = this.getParams();
        Object other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        RequestOptions this$options = this.getOptions();
        RequestOptions other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicexRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiResource.RequestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        HttpContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Object $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        RequestOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }

    public String toString() {
        return "BasicexRequest(method=" + (Object)((Object)this.getMethod()) + ", url=" + this.getUrl() + ", content=" + this.getContent() + ", headers=" + this.getHeaders() + ", params=" + this.getParams() + ", options=" + this.getOptions() + ")";
    }
}

