/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.net;

import com.basicex.sdk.exception.ApiConnectionException;
import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.net.BasicexRequest;
import com.basicex.sdk.net.BasicexResponse;
import com.basicex.sdk.net.BasicexResponseStream;
import com.basicex.sdk.net.HttpClient;
import com.basicex.sdk.net.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpURLConnectionClient
extends HttpClient {
    @Override
    public BasicexResponseStream requestStream(BasicexRequest request) throws ApiConnectionException {
        try {
            HttpURLConnection conn = HttpURLConnectionClient.createConnection(request);
            int responseCode = conn.getResponseCode();
            HttpHeaders headers = HttpHeaders.of(conn.getHeaderFields());
            InputStream responseStream = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            return new BasicexResponseStream(responseCode, headers, responseStream);
        }
        catch (IOException e) {
            throw new ApiConnectionException(String.format("IOException during API request to BasicEx (%s): %s", request.getOptions().getApiBaseUrl(), e.getMessage()), e);
        }
    }

    @Override
    public BasicexResponse request(BasicexRequest request) throws BasicexException {
        BasicexResponseStream responseStream = this.requestStream(request);
        try {
            return responseStream.unstream();
        }
        catch (IOException e) {
            throw new ApiConnectionException(String.format("IOException during API request to BasicEx (%s): %s ", request.getOptions().getApiBaseUrl(), e.getMessage()), e);
        }
    }

    private static HttpHeaders getHeaders(BasicexRequest request) {
        HashMap<String, List<String>> userAgentHeadersMap = new HashMap<String, List<String>>();
        userAgentHeadersMap.put("User-Agent", Collections.singletonList(HttpURLConnectionClient.buildUserAgentString()));
        return request.getHeaders().withAdditionalHeaders(userAgentHeadersMap);
    }

    private static HttpURLConnection createConnection(final BasicexRequest request) throws IOException, ApiConnectionException {
        HttpURLConnection conn = null;
        if (request.getOptions().getConnectionProxy() != null) {
            conn = (HttpURLConnection)request.getUrl().openConnection(request.getOptions().getConnectionProxy());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return request.getOptions().getProxyCredential();
                }
            });
        } else {
            conn = (HttpURLConnection)request.getUrl().openConnection();
        }
        conn.setConnectTimeout(request.getOptions().getConnectTimeout());
        conn.setReadTimeout(request.getOptions().getReadTimeout());
        conn.setUseCaches(false);
        for (Map.Entry<String, List<String>> entry : HttpURLConnectionClient.getHeaders(request).map().entrySet()) {
            conn.setRequestProperty(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        conn.setRequestMethod(request.getMethod().name());
        if (request.getContent() != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", request.getContent().getContentType());
            try (OutputStream output = conn.getOutputStream();){
                output.write(request.getContent().getByteArrayContent());
            }
        }
        return conn;
    }
}

