/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.service;

import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.model.InvoiceObject;
import com.basicex.sdk.model.params.InvoiceCreateParams;
import com.basicex.sdk.model.params.InvoiceUpdateParams;
import com.basicex.sdk.model.params.constant.ChainNetwork;
import com.basicex.sdk.model.request.InvoiceCreateRequest;
import com.basicex.sdk.model.request.InvoiceUpdateRequest;
import com.basicex.sdk.net.ApiResource;
import com.basicex.sdk.net.BasicexResponseGetter;
import com.basicex.sdk.net.RequestOptions;
import com.basicex.sdk.net.TypeReference;
import com.basicex.sdk.service.ApiService;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

public class InvoiceService
extends ApiService {
    public InvoiceService(BasicexResponseGetter getter) {
        super(getter);
    }

    public InvoiceObject create(InvoiceCreateParams params) throws BasicexException {
        return this.create(params, null);
    }

    public InvoiceObject create(InvoiceCreateParams params, RequestOptions options) throws BasicexException {
        params.checkParams();
        InvoiceCreateRequest.InvoiceCreateRequestBuilder builder = InvoiceCreateRequest.builder();
        if (params.getAmount() != null) {
            if (params.getAmount().scale() == 0) {
                builder.amount(params.getAmount().multiply(BigDecimal.TEN.pow(2)).toBigInteger()).precision(2);
            } else {
                builder.amount(params.getAmount().multiply(BigDecimal.TEN.pow(params.getAmount().scale())).toBigInteger()).precision(params.getAmount().scale());
            }
            builder.amountType(params.getAmountType().getCode());
        }
        builder.buyerId(params.getBuyerId()).orderId(params.getOrderId()).fiat(params.getFiat()).currency(params.getCurrency()).forcedChain(Optional.ofNullable(params.getForcedChain()).map(ChainNetwork::getCode).orElse(null)).metadata(params.getMetadata()).payerEmail(params.getPayerEmail()).notificationUrl(params.getNotificationUrl()).redirectUrl(params.getRedirectUrl()).buyerIp(params.getBuyerIp()).sendPaidNotification(params.getSendPaidNotification()).description(params.getDescription()).physical(params.getPhysical());
        String path = "/invoices";
        return this.getResponseGetter().request(ApiResource.RequestMethod.POST, path, builder.build(), new TypeReference<InvoiceObject>(){}, true, options);
    }

    public InvoiceObject get(String invoiceID) throws BasicexException {
        return this.get(invoiceID, null);
    }

    public InvoiceObject get(String invoiceID, RequestOptions options) throws BasicexException {
        String path = String.format("/invoices/%s", invoiceID);
        return this.getResponseGetter().request(ApiResource.RequestMethod.GET, path, null, new TypeReference<InvoiceObject>(){}, true, options);
    }

    public InvoiceObject getByMerchantOrderId(String orderID) throws BasicexException {
        return this.getByMerchantOrderId(orderID, null);
    }

    public InvoiceObject getByMerchantOrderId(String orderID, RequestOptions options) throws BasicexException {
        String path = String.format("/invoices/merchant/%s", orderID);
        return this.getResponseGetter().request(ApiResource.RequestMethod.GET, path, null, new TypeReference<InvoiceObject>(){}, true, options);
    }

    public InvoiceObject update(String invoiceID, InvoiceUpdateParams params) throws BasicexException {
        return this.update(invoiceID, params, null);
    }

    public InvoiceObject update(String invoiceID, InvoiceUpdateParams params, RequestOptions options) throws BasicexException {
        params.checkParams();
        InvoiceUpdateRequest.InvoiceUpdateRequestBuilder builder = InvoiceUpdateRequest.builder();
        builder.chain(Optional.ofNullable(params.getChain()).map(ChainNetwork::getCode).orElse(null)).ignoreParameterFailed(params.getIgnoreParameterFailed()).payerEmail(params.getPayerEmail()).redirectUrl(params.getRedirectUrl()).currency(params.getCurrency());
        String path = String.format("/invoices/%s", Objects.requireNonNull(invoiceID));
        return this.getResponseGetter().request(ApiResource.RequestMethod.PUT, path, builder.build(), new TypeReference<InvoiceObject>(){}, true, options);
    }
}

