/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.service;

import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.model.PayoutObject;
import com.basicex.sdk.model.PayoutResp;
import com.basicex.sdk.model.params.PayoutCreateParams;
import com.basicex.sdk.model.request.PayoutCreateRequest;
import com.basicex.sdk.net.ApiResource;
import com.basicex.sdk.net.BasicexResponseGetter;
import com.basicex.sdk.net.RequestOptions;
import com.basicex.sdk.net.TypeReference;
import com.basicex.sdk.service.ApiService;
import java.math.BigDecimal;

public class PayoutService
extends ApiService {
    private static final String url = "/payouts";

    public PayoutService(BasicexResponseGetter responseGetter) {
        super(responseGetter);
    }

    public PayoutObject create(PayoutCreateParams params) throws BasicexException {
        return this.create(params, null);
    }

    public PayoutObject create(PayoutCreateParams params, RequestOptions options) throws BasicexException {
        params.checkParams();
        PayoutCreateRequest.PayoutCreateRequestBuilder payoutRequestBuilder = PayoutCreateRequest.builder();
        if (params.getAmount() != null) {
            payoutRequestBuilder.amount(params.getAmount().multiply(BigDecimal.TEN.pow(params.getAmount().scale())).toBigInteger()).precision(params.getAmount().scale());
        }
        payoutRequestBuilder.currency(params.getCurrency()).metadata(params.getMetadata()).notificationUrl(params.getNotificationUrl()).physical(params.getPhysical()).customerEmail(params.getCustomerEmail()).description(params.getDescription()).metadata(params.getMetadata()).customerIp(params.getCustomerIp()).physical(params.getPhysical()).targetType(params.getTargetType()).target(params.getTarget()).merOrderNo(params.getMerOrderNo()).network(params.getNetwork());
        return this.getResponseGetter().request(ApiResource.RequestMethod.POST, url, payoutRequestBuilder.build(), new TypeReference<PayoutObject>(){}, true, options);
    }

    public PayoutResp get(String orderNo) throws BasicexException {
        return this.get(orderNo, null);
    }

    public PayoutResp get(String orderNo, RequestOptions options) throws BasicexException {
        String path = String.format("/payouts/%s", orderNo);
        return this.getResponseGetter().request(ApiResource.RequestMethod.GET, path, null, new TypeReference<PayoutResp>(){}, true, options);
    }
}

