/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.model.params;

import com.basicex.sdk.util.Preconditions;
import com.basicex.sdk.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;

public class PayoutCreateParams {
    private BigDecimal amount;
    private String currency;
    private String customerEmail;
    private String notificationUrl;
    private String description;
    private Map<String, String> metadata;
    private String customerIp;
    private Boolean physical = false;
    private String targetType;
    private String target;
    private String merOrderNo;
    private String network;

    public void checkParams() {
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.target), "target is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.currency), "currency is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.targetType), "targetType is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.description), "description is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.notificationUrl), "notificationUrl is required");
    }

    PayoutCreateParams(BigDecimal amount, String currency, String customerEmail, String notificationUrl, String description, Map<String, String> metadata, String customerIp, Boolean physical, String targetType, String target, String merOrderNo, String network) {
        this.amount = amount;
        this.currency = currency;
        this.customerEmail = customerEmail;
        this.notificationUrl = notificationUrl;
        this.description = description;
        this.metadata = metadata;
        this.customerIp = customerIp;
        this.physical = physical;
        this.targetType = targetType;
        this.target = target;
        this.merOrderNo = merOrderNo;
        this.network = network;
    }

    public static PayoutCreateParamsBuilder builder() {
        return new PayoutCreateParamsBuilder();
    }

    public PayoutCreateParamsBuilder toBuilder() {
        return new PayoutCreateParamsBuilder().amount(this.amount).currency(this.currency).customerEmail(this.customerEmail).notificationUrl(this.notificationUrl).description(this.description).metadata(this.metadata).customerIp(this.customerIp).physical(this.physical).targetType(this.targetType).target(this.target).merOrderNo(this.merOrderNo).network(this.network);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getCustomerIp() {
        return this.customerIp;
    }

    public Boolean getPhysical() {
        return this.physical;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTarget() {
        return this.target;
    }

    public String getMerOrderNo() {
        return this.merOrderNo;
    }

    public String getNetwork() {
        return this.network;
    }

    public static class PayoutCreateParamsBuilder {
        private BigDecimal amount;
        private String currency;
        private String customerEmail;
        private String notificationUrl;
        private String description;
        private Map<String, String> metadata;
        private String customerIp;
        private Boolean physical;
        private String targetType;
        private String target;
        private String merOrderNo;
        private String network;

        PayoutCreateParamsBuilder() {
        }

        public PayoutCreateParamsBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public PayoutCreateParamsBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public PayoutCreateParamsBuilder customerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
            return this;
        }

        public PayoutCreateParamsBuilder notificationUrl(String notificationUrl) {
            this.notificationUrl = notificationUrl;
            return this;
        }

        public PayoutCreateParamsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PayoutCreateParamsBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PayoutCreateParamsBuilder customerIp(String customerIp) {
            this.customerIp = customerIp;
            return this;
        }

        public PayoutCreateParamsBuilder physical(Boolean physical) {
            this.physical = physical;
            return this;
        }

        public PayoutCreateParamsBuilder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public PayoutCreateParamsBuilder target(String target) {
            this.target = target;
            return this;
        }

        public PayoutCreateParamsBuilder merOrderNo(String merOrderNo) {
            this.merOrderNo = merOrderNo;
            return this;
        }

        public PayoutCreateParamsBuilder network(String network) {
            this.network = network;
            return this;
        }

        public PayoutCreateParams build() {
            return new PayoutCreateParams(this.amount, this.currency, this.customerEmail, this.notificationUrl, this.description, this.metadata, this.customerIp, this.physical, this.targetType, this.target, this.merOrderNo, this.network);
        }

        public String toString() {
            return "PayoutCreateParams.PayoutCreateParamsBuilder(amount=" + this.amount + ", currency=" + this.currency + ", customerEmail=" + this.customerEmail + ", notificationUrl=" + this.notificationUrl + ", description=" + this.description + ", metadata=" + this.metadata + ", customerIp=" + this.customerIp + ", physical=" + this.physical + ", targetType=" + this.targetType + ", target=" + this.target + ", merOrderNo=" + this.merOrderNo + ", network=" + this.network + ")";
        }
    }
}

