/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.net;

import com.basicex.sdk.net.ApiResource;
import com.basicex.sdk.net.FormEncoder;
import com.basicex.sdk.net.KeyValuePair;
import com.basicex.sdk.net.MultipartProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;

public class HttpContent {
    private final byte[] byteArrayContent;
    private final String contentType;

    private HttpContent(byte[] byteArrayContent, String contentType) {
        this.byteArrayContent = byteArrayContent;
        this.contentType = contentType;
    }

    public static HttpContent buildFormURLEncodedContent(Collection<KeyValuePair<String, String>> nameValueCollection) throws IOException {
        Objects.requireNonNull(nameValueCollection);
        return new HttpContent(FormEncoder.createQueryString(nameValueCollection).getBytes(ApiResource.CHARSET), String.format("application/x-www-form-urlencoded;charset=%s", ApiResource.CHARSET));
    }

    public String stringContent() {
        return new String(this.byteArrayContent, ApiResource.CHARSET);
    }

    public static HttpContent buildMultipartFormDataContent(Collection<KeyValuePair<String, Object>> nameValueCollection) throws IOException {
        String boundary = UUID.randomUUID().toString();
        return HttpContent.buildMultipartFormDataContent(nameValueCollection, boundary);
    }

    public static HttpContent buildApplicationJsonContent(Object params) throws IOException {
        String body = ApiResource.GSON.toJson(params);
        return new HttpContent(body.getBytes(), String.format("application/json;charset=%s", ApiResource.CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpContent buildMultipartFormDataContent(Collection<KeyValuePair<String, Object>> nameValueCollection, String boundary) throws IOException {
        Objects.requireNonNull(nameValueCollection);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MultipartProcessor multipartProcessor = null;
        try {
            multipartProcessor = new MultipartProcessor(baos, boundary, ApiResource.CHARSET);
            for (KeyValuePair<String, Object> entry : nameValueCollection) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof File) {
                    File file = (File)value;
                    multipartProcessor.addFileField(key, file.getName(), new FileInputStream(file));
                    continue;
                }
                if (value instanceof InputStream) {
                    multipartProcessor.addFileField(key, "blob", (InputStream)value);
                    continue;
                }
                multipartProcessor.addFormField(key, (String)value);
            }
        }
        finally {
            if (multipartProcessor != null) {
                multipartProcessor.finish();
            }
        }
        return new HttpContent(baos.toByteArray(), String.format("multipart/form-data; boundary=%s", boundary));
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getByteArrayContent() {
        return this.byteArrayContent;
    }
}

