/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk;

import com.basicex.sdk.BasicExConfig;
import com.basicex.sdk.net.BasicexResponseGetter;
import com.basicex.sdk.net.HttpClient;
import com.basicex.sdk.net.SignatureResponseGetter;
import com.basicex.sdk.service.InvoiceService;
import com.basicex.sdk.service.PayoutService;
import com.basicex.sdk.service.PlatformService;
import com.basicex.sdk.service.RateService;
import com.basicex.sdk.service.WebhookService;
import com.basicex.sdk.util.PrivateKeyUtils;
import com.basicex.sdk.util.X509CertificateUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public class BasicExClient {
    private BasicexResponseGetter responseGetter;

    public BasicExClient(String configFilePath) throws CertificateException, IOException {
        BasicExConfig config = BasicExConfig.loadConfig(configFilePath);
        this.responseGetter = new SignatureResponseGetter(config);
    }

    public BasicExClient(String configFilePath, BasicExConfig config) throws CertificateException, IOException {
        BasicExConfig configBuilder = BasicExConfig.loadConfig(configFilePath);
        this.responseGetter = new SignatureResponseGetter(BasicExConfig.merge(configBuilder, config));
    }

    public BasicExClient(String privateKeyFilePath, String certificateFilePath) throws IOException, CertificateException {
        byte[] privateKeyBytes = Files.readAllBytes(Paths.get(new File(privateKeyFilePath).toURI()));
        byte[] certificateBytes = Files.readAllBytes(Paths.get(new File(certificateFilePath).toURI()));
        PrivateKey privateKey = PrivateKeyUtils.loadPrivateKey(new String(privateKeyBytes));
        List<X509Certificate> certificateList = X509CertificateUtils.toX509CertificateList(new String(certificateBytes));
        if (certificateList == null || certificateList.isEmpty()) {
            throw new NullPointerException("certificateList is null or empty");
        }
        BasicExConfig config = BasicExConfig.builder().privateKey(privateKey).certificate(certificateList.get(0)).build();
        this.responseGetter = new SignatureResponseGetter(config);
    }

    public BasicExClient(PrivateKey privateKey, X509Certificate certificate) throws IOException {
        BasicExConfig config = BasicExConfig.builder().privateKey(privateKey).certificate(certificate).build();
        this.responseGetter = new SignatureResponseGetter(config);
    }

    public BasicExClient(BasicExConfig config) {
        this(config, null);
    }

    public BasicExClient(BasicExConfig config, HttpClient client) {
        this.responseGetter = new SignatureResponseGetter(client, config);
    }

    public InvoiceService invoices() {
        return new InvoiceService(this.responseGetter);
    }

    public PayoutService payouts() {
        return new PayoutService(this.responseGetter);
    }

    public WebhookService webhook() {
        return new WebhookService(this.responseGetter);
    }

    public PlatformService platform() {
        return new PlatformService(this.responseGetter);
    }

    public RateService rates() {
        return new RateService(this.responseGetter);
    }

    public BasicexResponseGetter getResponseGetter() {
        return this.responseGetter;
    }
}

