/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk;

import com.basicex.sdk.ConfigFileLoader;
import com.basicex.sdk.util.StringUtils;
import com.basicex.sdk.util.X509CertificateUtils;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class BasicExConfig {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 80000;
    private volatile PrivateKey privateKey;
    private volatile X509Certificate certificate;
    private volatile String certificateSerialNumber;
    private volatile String merchantCode;
    private volatile int connectTimeout = 30000;
    private volatile int readTimeout = 80000;
    private volatile int maxNetworkRetries = 0;
    private volatile Proxy connectionProxy = null;
    private volatile PasswordAuthentication proxyCredential = null;
    private volatile String apiBaseUrl = "https://openapi.basicex.com/v2";

    private BasicExConfig() {
    }

    public BasicExConfig(PrivateKey privateKey, X509Certificate certificate, String certificateSerialNumber, String merchantCode, int connectTimeout, int readTimeout, int maxNetworkRetries, Proxy connectionProxy, PasswordAuthentication proxyCredential, String apiBaseUrl) {
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.certificateSerialNumber = certificateSerialNumber;
        this.merchantCode = merchantCode;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.connectionProxy = connectionProxy;
        this.proxyCredential = proxyCredential;
        this.apiBaseUrl = apiBaseUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BasicExConfig loadConfig(String configFilePath) throws IOException, CertificateException {
        return ConfigFileLoader.load(configFilePath);
    }

    public static BasicExConfig merge(BasicExConfig old, BasicExConfig config) {
        if (old == null) {
            return new BasicExConfig(config.getPrivateKey(), config.getCertificate(), config.getCertificateSerialNumber(), config.getMerchantCode(), config.getConnectTimeout(), config.getReadTimeout(), config.getMaxNetworkRetries(), config.getConnectionProxy(), config.getProxyCredential(), config.getApiBaseUrl());
        }
        return new BasicExConfig(config.getPrivateKey() != null ? config.getPrivateKey() : old.getPrivateKey(), config.getCertificate() != null ? config.getCertificate() : old.getCertificate(), old.getCertificateSerialNumber(), old.getMerchantCode(), config.getConnectTimeout() != 0 ? config.getConnectTimeout() : old.getConnectTimeout(), config.getReadTimeout() != 0 ? config.getReadTimeout() : old.getReadTimeout(), config.getMaxNetworkRetries() != 0 ? config.getMaxNetworkRetries() : old.getMaxNetworkRetries(), config.getConnectionProxy() != null ? config.getConnectionProxy() : old.getConnectionProxy(), config.getProxyCredential() != null ? config.getProxyCredential() : old.getProxyCredential(), config.getApiBaseUrl() != null ? config.getApiBaseUrl() : old.getApiBaseUrl());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public String getMerchantCode() {
        return this.merchantCode;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setCertificateSerialNumber(String certificateSerialNumber) {
        this.certificateSerialNumber = certificateSerialNumber;
    }

    public void setMerchantCode(String merchantCode) {
        this.merchantCode = merchantCode;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setMaxNetworkRetries(int maxNetworkRetries) {
        this.maxNetworkRetries = maxNetworkRetries;
    }

    public void setConnectionProxy(Proxy connectionProxy) {
        this.connectionProxy = connectionProxy;
    }

    public void setProxyCredential(PasswordAuthentication proxyCredential) {
        this.proxyCredential = proxyCredential;
    }

    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicExConfig)) {
            return false;
        }
        BasicExConfig other = (BasicExConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getMaxNetworkRetries() != other.getMaxNetworkRetries()) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        X509Certificate this$certificate = this.getCertificate();
        X509Certificate other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        String this$certificateSerialNumber = this.getCertificateSerialNumber();
        String other$certificateSerialNumber = other.getCertificateSerialNumber();
        if (this$certificateSerialNumber == null ? other$certificateSerialNumber != null : !this$certificateSerialNumber.equals(other$certificateSerialNumber)) {
            return false;
        }
        String this$merchantCode = this.getMerchantCode();
        String other$merchantCode = other.getMerchantCode();
        if (this$merchantCode == null ? other$merchantCode != null : !this$merchantCode.equals(other$merchantCode)) {
            return false;
        }
        Proxy this$connectionProxy = this.getConnectionProxy();
        Proxy other$connectionProxy = other.getConnectionProxy();
        if (this$connectionProxy == null ? other$connectionProxy != null : !((Object)this$connectionProxy).equals(other$connectionProxy)) {
            return false;
        }
        PasswordAuthentication this$proxyCredential = this.getProxyCredential();
        PasswordAuthentication other$proxyCredential = other.getProxyCredential();
        if (this$proxyCredential == null ? other$proxyCredential != null : !this$proxyCredential.equals(other$proxyCredential)) {
            return false;
        }
        String this$apiBaseUrl = this.getApiBaseUrl();
        String other$apiBaseUrl = other.getApiBaseUrl();
        return !(this$apiBaseUrl == null ? other$apiBaseUrl != null : !this$apiBaseUrl.equals(other$apiBaseUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicExConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getMaxNetworkRetries();
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        X509Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        String $certificateSerialNumber = this.getCertificateSerialNumber();
        result = result * 59 + ($certificateSerialNumber == null ? 43 : $certificateSerialNumber.hashCode());
        String $merchantCode = this.getMerchantCode();
        result = result * 59 + ($merchantCode == null ? 43 : $merchantCode.hashCode());
        Proxy $connectionProxy = this.getConnectionProxy();
        result = result * 59 + ($connectionProxy == null ? 43 : ((Object)$connectionProxy).hashCode());
        PasswordAuthentication $proxyCredential = this.getProxyCredential();
        result = result * 59 + ($proxyCredential == null ? 43 : $proxyCredential.hashCode());
        String $apiBaseUrl = this.getApiBaseUrl();
        result = result * 59 + ($apiBaseUrl == null ? 43 : $apiBaseUrl.hashCode());
        return result;
    }

    public String toString() {
        return "BasicExConfig(privateKey=" + this.getPrivateKey() + ", certificate=" + this.getCertificate() + ", certificateSerialNumber=" + this.getCertificateSerialNumber() + ", merchantCode=" + this.getMerchantCode() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", maxNetworkRetries=" + this.getMaxNetworkRetries() + ", connectionProxy=" + this.getConnectionProxy() + ", proxyCredential=" + this.getProxyCredential() + ", apiBaseUrl=" + this.getApiBaseUrl() + ")";
    }

    public static class Builder {
        private final BasicExConfig config;

        private Builder(BasicExConfig config) {
            this.config = config;
        }

        private Builder() {
            this(new BasicExConfig());
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.config.privateKey = Objects.requireNonNull(privateKey, "privateKey must not be null");
            return this;
        }

        public Builder certificate(X509Certificate certificate) throws IOException {
            this.config.certificate = Objects.requireNonNull(certificate, "certificate must not be null");
            this.config.certificateSerialNumber = X509CertificateUtils.getCertificateSerialNo(certificate);
            this.config.merchantCode = X509CertificateUtils.getCommonNameFromCertificate(certificate);
            return this;
        }

        public Builder connectionProxy(Proxy connectionProxy) {
            this.config.connectionProxy = connectionProxy;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.config.connectTimeout = connectTimeout;
            return this;
        }

        public Builder maxNetworkRetries(int maxNetworkRetries) {
            this.config.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public Builder proxyCredential(PasswordAuthentication proxyCredential) {
            this.config.proxyCredential = proxyCredential;
            return this;
        }

        public Builder proxy(Proxy connectionProxy, PasswordAuthentication proxyCredential) {
            this.config.connectionProxy = connectionProxy;
            this.config.proxyCredential = proxyCredential;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.config.readTimeout = readTimeout;
            return this;
        }

        public Builder apiBaseUrl(String apiBaseUrl) {
            if (StringUtils.isNotEmpty(apiBaseUrl)) {
                this.config.apiBaseUrl = apiBaseUrl;
            }
            return this;
        }

        public BasicExConfig build() {
            return this.config;
        }
    }
}

