/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk;

import com.basicex.sdk.BasicExConfig;
import com.basicex.sdk.model.JsonConfigModel;
import com.basicex.sdk.util.PrivateKeyUtils;
import com.basicex.sdk.util.X509CertificateUtils;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public class ConfigFileLoader {
    public static BasicExConfig load(String configFilePath) throws IOException, CertificateException {
        JsonConfigModel configModel = ConfigFileLoader.loadJson(configFilePath);
        if (configModel == null) {
            throw new NullPointerException("configModel is null");
        }
        PrivateKey privateKey = PrivateKeyUtils.loadPrivateKey(configModel.getPrivateKey());
        List<X509Certificate> certificateList = X509CertificateUtils.toX509CertificateList(configModel.getCertificate());
        if (certificateList == null || certificateList.isEmpty()) {
            throw new NullPointerException("certificateList is null or empty");
        }
        return BasicExConfig.builder().privateKey(privateKey).certificate(certificateList.get(0)).apiBaseUrl(configModel.getApiBaseUrl()).build();
    }

    private static JsonConfigModel loadJson(String configPath) throws IOException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        try (BufferedReader input = Files.newBufferedReader(Paths.get(configPath, new String[0]));){
            JsonConfigModel jsonConfigModel = (JsonConfigModel)gson.fromJson((Reader)input, JsonConfigModel.class);
            return jsonConfigModel;
        }
    }
}

