/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.model.params;

import com.basicex.sdk.model.params.constant.AmountType;
import com.basicex.sdk.model.params.constant.ChainNetwork;
import com.basicex.sdk.util.Preconditions;
import com.basicex.sdk.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;

public class InvoiceCreateParams {
    private String buyerId;
    private String orderId;
    private String fiat;
    private String currency;
    private ChainNetwork forcedChain;
    private BigDecimal amount;
    private AmountType amountType;
    private String description;
    private Map<String, String> metadata;
    private String payerEmail;
    private String notificationUrl;
    private String redirectUrl;
    private String buyerIp;
    private Boolean sendPaidNotification;
    private Boolean physical;

    public void checkParams() {
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.orderId), "orderId is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.description), "description is required");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.notificationUrl), "notificationUrl is required");
        if (this.amountType != null) {
            Preconditions.checkArgument(this.amount != null, "amount is required");
            if (this.amountType.equals((Object)AmountType.COIN_AMOUNT) && StringUtils.isEmpty(this.currency)) {
                throw new IllegalArgumentException("currency is required");
            }
        }
        if (this.forcedChain != null) {
            Preconditions.checkArgument(StringUtils.isNotEmpty(this.currency), "currency is required");
            Preconditions.checkArgument(this.amount != null, "amount is required");
            Preconditions.checkArgument(this.amountType != null, "amountType is required");
        }
    }

    private static Boolean $default$sendPaidNotification() {
        return false;
    }

    private static Boolean $default$physical() {
        return false;
    }

    InvoiceCreateParams(String buyerId, String orderId, String fiat, String currency, ChainNetwork forcedChain, BigDecimal amount, AmountType amountType, String description, Map<String, String> metadata, String payerEmail, String notificationUrl, String redirectUrl, String buyerIp, Boolean sendPaidNotification, Boolean physical) {
        this.buyerId = buyerId;
        this.orderId = orderId;
        this.fiat = fiat;
        this.currency = currency;
        this.forcedChain = forcedChain;
        this.amount = amount;
        this.amountType = amountType;
        this.description = description;
        this.metadata = metadata;
        this.payerEmail = payerEmail;
        this.notificationUrl = notificationUrl;
        this.redirectUrl = redirectUrl;
        this.buyerIp = buyerIp;
        this.sendPaidNotification = sendPaidNotification;
        this.physical = physical;
    }

    public static InvoiceCreateParamsBuilder builder() {
        return new InvoiceCreateParamsBuilder();
    }

    public InvoiceCreateParamsBuilder toBuilder() {
        return new InvoiceCreateParamsBuilder().buyerId(this.buyerId).orderId(this.orderId).fiat(this.fiat).currency(this.currency).forcedChain(this.forcedChain).amount(this.amount).amountType(this.amountType).description(this.description).metadata(this.metadata).payerEmail(this.payerEmail).notificationUrl(this.notificationUrl).redirectUrl(this.redirectUrl).buyerIp(this.buyerIp).sendPaidNotification(this.sendPaidNotification).physical(this.physical);
    }

    public String getBuyerId() {
        return this.buyerId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getFiat() {
        return this.fiat;
    }

    public String getCurrency() {
        return this.currency;
    }

    public ChainNetwork getForcedChain() {
        return this.forcedChain;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public AmountType getAmountType() {
        return this.amountType;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getPayerEmail() {
        return this.payerEmail;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getBuyerIp() {
        return this.buyerIp;
    }

    public Boolean getSendPaidNotification() {
        return this.sendPaidNotification;
    }

    public Boolean getPhysical() {
        return this.physical;
    }

    public static class InvoiceCreateParamsBuilder {
        private String buyerId;
        private String orderId;
        private String fiat;
        private String currency;
        private ChainNetwork forcedChain;
        private BigDecimal amount;
        private AmountType amountType;
        private String description;
        private Map<String, String> metadata;
        private String payerEmail;
        private String notificationUrl;
        private String redirectUrl;
        private String buyerIp;
        private boolean sendPaidNotification$set;
        private Boolean sendPaidNotification$value;
        private boolean physical$set;
        private Boolean physical$value;

        InvoiceCreateParamsBuilder() {
        }

        public InvoiceCreateParamsBuilder buyerId(String buyerId) {
            this.buyerId = buyerId;
            return this;
        }

        public InvoiceCreateParamsBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public InvoiceCreateParamsBuilder fiat(String fiat) {
            this.fiat = fiat;
            return this;
        }

        public InvoiceCreateParamsBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public InvoiceCreateParamsBuilder forcedChain(ChainNetwork forcedChain) {
            this.forcedChain = forcedChain;
            return this;
        }

        public InvoiceCreateParamsBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public InvoiceCreateParamsBuilder amountType(AmountType amountType) {
            this.amountType = amountType;
            return this;
        }

        public InvoiceCreateParamsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InvoiceCreateParamsBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public InvoiceCreateParamsBuilder payerEmail(String payerEmail) {
            this.payerEmail = payerEmail;
            return this;
        }

        public InvoiceCreateParamsBuilder notificationUrl(String notificationUrl) {
            this.notificationUrl = notificationUrl;
            return this;
        }

        public InvoiceCreateParamsBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public InvoiceCreateParamsBuilder buyerIp(String buyerIp) {
            this.buyerIp = buyerIp;
            return this;
        }

        public InvoiceCreateParamsBuilder sendPaidNotification(Boolean sendPaidNotification) {
            this.sendPaidNotification$value = sendPaidNotification;
            this.sendPaidNotification$set = true;
            return this;
        }

        public InvoiceCreateParamsBuilder physical(Boolean physical) {
            this.physical$value = physical;
            this.physical$set = true;
            return this;
        }

        public InvoiceCreateParams build() {
            Boolean sendPaidNotification$value = this.sendPaidNotification$value;
            if (!this.sendPaidNotification$set) {
                sendPaidNotification$value = InvoiceCreateParams.$default$sendPaidNotification();
            }
            Boolean physical$value = this.physical$value;
            if (!this.physical$set) {
                physical$value = InvoiceCreateParams.$default$physical();
            }
            return new InvoiceCreateParams(this.buyerId, this.orderId, this.fiat, this.currency, this.forcedChain, this.amount, this.amountType, this.description, this.metadata, this.payerEmail, this.notificationUrl, this.redirectUrl, this.buyerIp, sendPaidNotification$value, physical$value);
        }

        public String toString() {
            return "InvoiceCreateParams.InvoiceCreateParamsBuilder(buyerId=" + this.buyerId + ", orderId=" + this.orderId + ", fiat=" + this.fiat + ", currency=" + this.currency + ", forcedChain=" + (Object)((Object)this.forcedChain) + ", amount=" + this.amount + ", amountType=" + (Object)((Object)this.amountType) + ", description=" + this.description + ", metadata=" + this.metadata + ", payerEmail=" + this.payerEmail + ", notificationUrl=" + this.notificationUrl + ", redirectUrl=" + this.redirectUrl + ", buyerIp=" + this.buyerIp + ", sendPaidNotification$value=" + this.sendPaidNotification$value + ", physical$value=" + this.physical$value + ")";
        }
    }
}

