/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.net;

import com.basicex.sdk.net.HttpHeaders;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractBasicexResponse<T> {
    private final int code;
    private final HttpHeaders headers;
    private final T body;
    private int numRetries;

    public final int getCode() {
        return this.code;
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final T getBody() {
        return this.body;
    }

    public Instant getDate() {
        Optional<String> dateStr = this.headers.firstValue("Date");
        if (!dateStr.isPresent()) {
            return null;
        }
        return ZonedDateTime.parse(dateStr.get(), DateTimeFormatter.RFC_1123_DATE_TIME).toInstant();
    }

    protected AbstractBasicexResponse(int code, HttpHeaders headers, T body) {
        Objects.requireNonNull(headers);
        Objects.requireNonNull(body);
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    public String getRequestId() {
        return this.headers.firstValue("Request-Id").orElse(null);
    }
}

