/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.net;

import com.basicex.sdk.BasicExConfig;
import com.basicex.sdk.exception.ApiConnectionException;
import com.basicex.sdk.exception.ApiException;
import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.exception.InvalidRequestException;
import com.basicex.sdk.exception.RateLimitException;
import com.basicex.sdk.exception.SignatureException;
import com.basicex.sdk.model.BasicexError;
import com.basicex.sdk.net.ApiResource;
import com.basicex.sdk.net.BasicexRequest;
import com.basicex.sdk.net.BasicexResponse;
import com.basicex.sdk.net.BasicexResponseGetter;
import com.basicex.sdk.net.BasicexResponseStream;
import com.basicex.sdk.net.HttpClient;
import com.basicex.sdk.net.HttpURLConnectionClient;
import com.basicex.sdk.net.RequestOptions;
import com.basicex.sdk.net.TypeReference;
import com.basicex.sdk.util.PrivateKeyUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import org.bouncycastle.util.encoders.Base64;

public class SignatureResponseGetter
implements BasicexResponseGetter {
    private final HttpClient httpClient;
    private final BasicExConfig config;

    public SignatureResponseGetter(HttpClient httpClient, BasicExConfig config) {
        this.httpClient = httpClient != null ? httpClient : SignatureResponseGetter.buildDefaultHttpClient();
        this.config = config;
    }

    public SignatureResponseGetter(BasicExConfig config) {
        this(null, config);
    }

    @Override
    public <T> T request(ApiResource.RequestMethod method, String path, Object params, TypeReference<T> typeToken, Boolean signRequest, RequestOptions options) throws BasicexException {
        String fullUrl = String.format("%s%s", Optional.ofNullable(options).map(x -> Optional.ofNullable(x.getApiBaseUrl()).orElse(this.config.getApiBaseUrl())).orElse(this.config.getApiBaseUrl()), path);
        BasicexRequest request = new BasicexRequest(method, fullUrl, params, RequestOptions.merge(options, this.config));
        if (signRequest.booleanValue()) {
            request.setHeaders(request.getHeaders().withAdditionalHeader("X-Signature", this.signature(params, path, request.getOptions())));
        }
        BasicexResponse response = this.httpClient.requestWithRetries(request);
        int responseCode = response.getCode();
        String responseBody = (String)response.getBody();
        String requestId = response.getRequestId();
        if (responseCode < 200 || responseCode >= 300) {
            SignatureResponseGetter.handleError(response);
        }
        Object resource = null;
        try {
            if (typeToken.getType() instanceof ParameterizedType && ((ParameterizedType)typeToken.getType()).getRawType().getTypeName().equals("java.util.List")) {
                JsonArray jsonArray = ((JsonObject)ApiResource.GSON.fromJson((String)response.getBody(), JsonObject.class)).getAsJsonArray("data");
                if (jsonArray != null) {
                    resource = ApiResource.GSON.fromJson((JsonElement)jsonArray, typeToken.getType());
                }
            } else {
                JsonObject jsonObject = ((JsonObject)ApiResource.GSON.fromJson((String)response.getBody(), JsonObject.class)).getAsJsonObject("data");
                if (jsonObject != null) {
                    resource = ApiResource.GSON.fromJson((JsonElement)jsonObject, typeToken.getType());
                }
            }
        }
        catch (JsonSyntaxException e) {
            SignatureResponseGetter.raiseMalformedJsonError(responseBody, responseCode, requestId, e);
        }
        return (T)resource;
    }

    @Override
    public InputStream requestStream(ApiResource.RequestMethod method, String path, Object params, Boolean signRequest, RequestOptions options) throws BasicexException {
        BasicexResponseStream responseStream;
        int responseCode;
        String fullUrl = String.format("%s%s", Optional.ofNullable(options).map(x -> Optional.ofNullable(x.getApiBaseUrl()).orElse(this.config.getApiBaseUrl())).orElse(this.config.getApiBaseUrl()), path);
        BasicexRequest request = new BasicexRequest(method, fullUrl, params, RequestOptions.merge(options, this.config));
        if (signRequest.booleanValue()) {
            request.getHeaders().withAdditionalHeader("X-Signature", this.signature(params, path, request.getOptions()));
        }
        if ((responseCode = (responseStream = this.httpClient.requestStreamWithRetries(request)).getCode()) < 200 || responseCode >= 300) {
            BasicexResponse response;
            try {
                response = responseStream.unstream();
            }
            catch (IOException e) {
                throw new ApiConnectionException(String.format("IOException during API request to BasicEx (%s): %s ", request.getOptions().getApiBaseUrl(), e.getMessage()), e);
            }
            SignatureResponseGetter.handleError(response);
        }
        return (InputStream)responseStream.getBody();
    }

    private String signature(Object params, String path, RequestOptions options) throws SignatureException {
        String signStr = Optional.ofNullable(params).map(arg_0 -> ((Gson)ApiResource.GSON).toJson(arg_0)).orElse(null);
        String signInput = options.getApiBaseUrl() + path + Optional.ofNullable(signStr).orElse("");
        try {
            byte[] sign = PrivateKeyUtils.sign(options.getPrivateKey(), options.getCertificate().getSigAlgName(), signInput.getBytes());
            return Base64.toBase64String((byte[])sign);
        }
        catch (Exception e) {
            throw new SignatureException("Signature failed:" + e.getMessage(), e);
        }
    }

    private static void handleError(BasicexResponse response) throws BasicexException {
        BasicexError error = null;
        BasicexException exception = null;
        try {
            error = (BasicexError)ApiResource.GSON.fromJson((String)response.getBody(), BasicexError.class);
        }
        catch (JsonSyntaxException e) {
            SignatureResponseGetter.raiseMalformedJsonError((String)response.getBody(), response.getCode(), response.getRequestId(), e);
        }
        if (error == null) {
            SignatureResponseGetter.raiseMalformedJsonError((String)response.getBody(), response.getCode(), response.getRequestId(), null);
        }
        error.setLastResponse(response);
        switch (response.getCode()) {
            case 400: 
            case 404: {
                exception = new InvalidRequestException(error.getMessage(), error.getParam(), response.getRequestId(), error.getCode(), response.getCode(), null);
                break;
            }
            case 401: {
                exception = new SignatureException(error.getMessage(), response.getRequestId(), error.getCode(), response.getCode());
                break;
            }
            case 429: {
                exception = new RateLimitException(error.getMessage(), response.getRequestId(), error.getCode(), response.getCode(), null);
                break;
            }
            default: {
                exception = new ApiException(error.getMessage(), response.getRequestId(), error.getCode(), response.getCode(), null);
            }
        }
        exception.setBasicexError(error);
        throw exception;
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode, String requestId, Throwable e) throws ApiException {
        String details = e == null ? "none" : e.getMessage();
        throw new ApiException(String.format("Invalid response object from API: %s. (HTTP response code was %d). Additional details: %s.", responseBody, responseCode, details), requestId, null, responseCode, e);
    }

    private static HttpClient buildDefaultHttpClient() {
        return new HttpURLConnectionClient();
    }
}

