/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class PrivateKeyUtils {
    public static PrivateKey loadPrivateKey(String privateKeyStr) throws IOException {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKeyStr));
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        Object object = pemParser.readObject();
        if (object instanceof PEMKeyPair) {
            return converter.getKeyPair((PEMKeyPair)object).getPrivate();
        }
        if (object instanceof PrivateKeyInfo) {
            return converter.getPrivateKey((PrivateKeyInfo)object);
        }
        return null;
    }

    public static byte[] sign(PrivateKey privateKey, String algorithm, byte[] input) throws Exception {
        Signature sign = Signature.getInstance(algorithm);
        sign.initSign(privateKey);
        sign.update(input);
        return sign.sign();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

