/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class X509CertificateUtils {
    public static String getCertificateSerialNo(X509Certificate certificate) {
        return X509CertificateUtils.formatByteArray(certificate.getSerialNumber().toByteArray());
    }

    public static String toPEMString(X509Certificate certificate) throws CertificateException, IOException {
        StringWriter stringWriter = new StringWriter();
        try (PemWriter pemWriter = new PemWriter((Writer)stringWriter);){
            PemObject pemObject = new PemObject("CERTIFICATE", certificate.getEncoded());
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        return stringWriter.toString();
    }

    public static String getCommonNameFromCertificate(X509Certificate certificate) throws IOException {
        X500Name subject = new X500Name(certificate.getSubjectX500Principal().getName());
        RDN[] rdns = subject.getRDNs(RFC4519Style.cn);
        if (rdns != null && rdns.length > 0) {
            return rdns[0].getFirst().getValue().toString();
        }
        return null;
    }

    public static List<X509Certificate> toX509CertificateList(String pemRaw) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        List certificates = (List)certificateFactory.generateCertificates(new ByteArrayInputStream(pemRaw.getBytes()));
        return certificates;
    }

    private static String formatByteArray(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x:", b));
        }
        return result.substring(0, result.length() - 1);
    }
}

