/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.net;

import com.basicex.sdk.exception.ApiConnectionException;
import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.net.AbstractBasicexResponse;
import com.basicex.sdk.net.BasicexRequest;
import com.basicex.sdk.net.BasicexResponse;
import com.basicex.sdk.net.BasicexResponseStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public abstract class HttpClient {
    public static final Duration maxNetworkRetriesDelay = Duration.ofSeconds(5L);
    public static final Duration minNetworkRetriesDelay = Duration.ofMillis(500L);
    boolean networkRetriesSleep = true;

    protected HttpClient() {
    }

    public abstract BasicexResponse request(BasicexRequest var1) throws BasicexException;

    public BasicexResponseStream requestStream(BasicexRequest request) throws BasicexException {
        throw new UnsupportedOperationException("requestStream is unimplemented for this HttpClient");
    }

    public <T extends AbstractBasicexResponse<?>> T sendWithRetries(BasicexRequest request, RequestSendFunction<T> send) throws BasicexException {
        ApiConnectionException requestException = null;
        AbstractBasicexResponse response = null;
        int retry = 0;
        while (true) {
            requestException = null;
            try {
                response = (AbstractBasicexResponse)send.apply(request);
            }
            catch (ApiConnectionException e) {
                requestException = e;
            }
            if (!this.shouldRetry(retry, requestException, request, response)) break;
            ++retry;
            try {
                Thread.sleep(this.sleepTime(retry).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (requestException != null) {
            throw requestException;
        }
        response.setNumRetries(retry);
        return (T)response;
    }

    public BasicexResponse requestWithRetries(BasicexRequest request) throws BasicexException {
        return this.sendWithRetries(request, this::request);
    }

    public BasicexResponseStream requestStreamWithRetries(BasicexRequest request) throws BasicexException {
        return this.sendWithRetries(request, this::requestStream);
    }

    protected static String buildUserAgentString() {
        String userAgent = String.format("BasicEx/v2 JavaBindings/%s", null);
        return userAgent;
    }

    private <T extends AbstractBasicexResponse<?>> boolean shouldRetry(int numRetries, BasicexException exception, BasicexRequest request, T response) {
        if (numRetries >= request.getOptions().getMaxNetworkRetries()) {
            return false;
        }
        if (exception != null && exception.getCause() != null && (exception.getCause() instanceof ConnectException || exception.getCause() instanceof SocketTimeoutException)) {
            return true;
        }
        return response != null && response.getCode() == 409;
    }

    private Duration sleepTime(int numRetries) {
        if (!this.networkRetriesSleep) {
            return Duration.ZERO;
        }
        Duration delay = Duration.ofNanos((long)((double)minNetworkRetriesDelay.toNanos() * Math.pow(2.0, numRetries - 1)));
        if (delay.compareTo(maxNetworkRetriesDelay) > 0) {
            delay = maxNetworkRetriesDelay;
        }
        double jitter = ThreadLocalRandom.current().nextDouble(0.75, 1.0);
        if ((delay = Duration.ofNanos((long)((double)delay.toNanos() * jitter))).compareTo(minNetworkRetriesDelay) < 0) {
            delay = minNetworkRetriesDelay;
        }
        return delay;
    }

    @FunctionalInterface
    private static interface RequestSendFunction<R> {
        public R apply(BasicexRequest var1) throws BasicexException;
    }
}

