/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.net;

import com.basicex.sdk.BasicExConfig;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class RequestOptions {
    private final X509Certificate certificate;
    private final PrivateKey privateKey;
    private final String apiBaseUrl;
    private final Integer connectTimeout;
    private final Integer readTimeout;
    private final Integer maxNetworkRetries;
    private final Proxy connectionProxy;
    private final PasswordAuthentication proxyCredential;

    public static RequestOptions getDefault() {
        return new RequestOptions(null, null, null, null, null, null, null, null);
    }

    private RequestOptions(X509Certificate certificate, PrivateKey privateKey, String apiBaseUrl, Integer connectTimeout, Integer readTimeout, Integer maxNetworkRetries, Proxy connectionProxy, PasswordAuthentication proxyCredential) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.apiBaseUrl = apiBaseUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.connectionProxy = connectionProxy;
        this.proxyCredential = proxyCredential;
    }

    public static RequestOptions merge(RequestOptions options, BasicExConfig config) {
        if (options == null) {
            return new RequestOptions(config.getCertificate(), config.getPrivateKey(), config.getApiBaseUrl(), config.getConnectTimeout(), config.getReadTimeout(), config.getMaxNetworkRetries(), config.getConnectionProxy(), config.getProxyCredential());
        }
        return new RequestOptions(options.getCertificate() != null ? options.getCertificate() : config.getCertificate(), options.getPrivateKey() != null ? options.getPrivateKey() : config.getPrivateKey(), options.getApiBaseUrl() != null ? options.getApiBaseUrl() : config.getApiBaseUrl(), options.getConnectTimeout() != null ? options.getConnectTimeout().intValue() : config.getConnectTimeout(), options.getReadTimeout() != null ? options.getReadTimeout().intValue() : config.getReadTimeout(), options.getMaxNetworkRetries() != null ? options.getMaxNetworkRetries().intValue() : config.getMaxNetworkRetries(), options.getConnectionProxy() != null ? options.getConnectionProxy() : config.getConnectionProxy(), options.getProxyCredential() != null ? options.getProxyCredential() : config.getProxyCredential());
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    public static class RequestOptionsBuilder {
        private X509Certificate certificate;
        private PrivateKey privateKey;
        private String apiBaseUrl;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Integer maxNetworkRetries;
        private Proxy connectionProxy;
        private PasswordAuthentication proxyCredential;

        RequestOptionsBuilder() {
        }

        public RequestOptionsBuilder certificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public RequestOptionsBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public RequestOptionsBuilder apiBaseUrl(String apiBaseUrl) {
            this.apiBaseUrl = apiBaseUrl;
            return this;
        }

        public RequestOptionsBuilder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public RequestOptionsBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public RequestOptionsBuilder maxNetworkRetries(Integer maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public RequestOptionsBuilder connectionProxy(Proxy connectionProxy) {
            this.connectionProxy = connectionProxy;
            return this;
        }

        public RequestOptionsBuilder proxyCredential(PasswordAuthentication proxyCredential) {
            this.proxyCredential = proxyCredential;
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this.certificate, this.privateKey, this.apiBaseUrl, this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.connectionProxy, this.proxyCredential);
        }

        public String toString() {
            return "RequestOptions.RequestOptionsBuilder(certificate=" + this.certificate + ", privateKey=" + this.privateKey + ", apiBaseUrl=" + this.apiBaseUrl + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", maxNetworkRetries=" + this.maxNetworkRetries + ", connectionProxy=" + this.connectionProxy + ", proxyCredential=" + this.proxyCredential + ")";
        }
    }
}

