/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.service;

import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.model.RefundObject;
import com.basicex.sdk.model.params.RefundCreateParams;
import com.basicex.sdk.model.request.RefundCreateRequest;
import com.basicex.sdk.net.ApiResource;
import com.basicex.sdk.net.BasicexResponseGetter;
import com.basicex.sdk.net.RequestOptions;
import com.basicex.sdk.net.TypeReference;
import com.basicex.sdk.service.ApiService;
import java.math.BigDecimal;

public class RefundService
extends ApiService {
    private static final String url = "/refunds";

    public RefundService(BasicexResponseGetter responseGetter) {
        super(responseGetter);
    }

    public RefundObject create(RefundCreateParams params) throws BasicexException {
        return this.create(params, null);
    }

    public RefundObject create(RefundCreateParams params, RequestOptions options) throws BasicexException {
        params.checkParams();
        RefundCreateRequest.RefundCreateRequestBuilder refundRequestBuilder = RefundCreateRequest.builder();
        if (params.getAmount() != null) {
            refundRequestBuilder.amount(params.getAmount().multiply(BigDecimal.TEN.pow(params.getAmount().scale())).toBigInteger()).precision(params.getAmount().scale());
        }
        refundRequestBuilder.coinPrecision(params.getCoinPrecision()).customerEmail(params.getCustomerEmail()).merOrderNo(params.getMerOrderNo()).amountType(params.getAmountType()).orderNo(params.getOrderNo()).merRefundOrderNo(params.getMerRefundOrderNo()).refundReason(params.getRefundReason()).tradeStartTime(params.getTradeStartTime()).customerEmail(params.getCustomerEmail());
        return this.getResponseGetter().request(ApiResource.RequestMethod.POST, url, refundRequestBuilder.build(), new TypeReference<RefundObject>(){}, true, options);
    }
}

