/*
 * Decompiled with CFR 0.152.
 */
package com.basicex.sdk.service;

import com.basicex.sdk.exception.BasicexException;
import com.basicex.sdk.exception.WebhookException;
import com.basicex.sdk.model.PlatformCertificateObject;
import com.basicex.sdk.model.params.constant.WebhookType;
import com.basicex.sdk.model.webhook.InvoiceCompletedWebhookMessage;
import com.basicex.sdk.model.webhook.InvoicePaidWebhookMessage;
import com.basicex.sdk.model.webhook.PayoutWebhookMessage;
import com.basicex.sdk.model.webhook.WebhookEvent;
import com.basicex.sdk.net.ApiResource;
import com.basicex.sdk.net.BasicexResponseGetter;
import com.basicex.sdk.net.TypeReference;
import com.basicex.sdk.service.ApiService;
import com.basicex.sdk.service.PlatformService;
import com.basicex.sdk.util.X509CertificateUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.bouncycastle.util.encoders.Base64;

public class WebhookService
extends ApiService {
    private final PlatformService platformService;

    public WebhookService(BasicexResponseGetter responseGetter) {
        super(responseGetter);
        this.platformService = new PlatformService(responseGetter);
    }

    public WebhookEvent<?> validate(HttpServletRequest request, String notificationUrl) throws BasicexException, IOException {
        if (request.getHeader("X-Webhook-Signature") == null || request.getHeader("X-Webhook-Signature-Serial") == null) {
            throw new com.basicex.sdk.exception.SignatureException("Webhook\u8bf7\u6c42\u5934\u7f3a\u5c11X-Webhook-Signature\u6216X-Webhook-Signature-Serial", null, null, null);
        }
        String signature = request.getHeader("X-Webhook-Signature");
        String serial = request.getHeader("X-Webhook-Signature-Serial");
        return this.validate(this.httpServletRequestToString(request), notificationUrl, signature, serial);
    }

    public WebhookEvent<?> validate(String requestBody, String notificationUrl, String signature, String certificateSerialNo) throws BasicexException {
        X509Certificate certificate = this.getPlatformCertificate(Objects.requireNonNull(certificateSerialNo));
        if (!this.validateSignature(String.format("%s%s", notificationUrl, requestBody).getBytes(), Base64.decode((String)signature), certificate)) {
            throw new com.basicex.sdk.exception.SignatureException("Signature verification failure, illegal webhook request", null, null, null);
        }
        JsonObject obj = (JsonObject)ApiResource.GSON.fromJson(requestBody, JsonObject.class);
        String typeStr = obj.get("type").getAsString();
        WebhookType type = WebhookType.fromType(typeStr);
        if (type == null) {
            throw new WebhookException("Unknown webhook type");
        }
        TypeReference typeToken = null;
        switch (type) {
            case INVOICE_COMPLETED: {
                typeToken = new TypeReference<WebhookEvent<InvoiceCompletedWebhookMessage>>(){};
                break;
            }
            case INVOICE_PAID: {
                typeToken = new TypeReference<WebhookEvent<InvoicePaidWebhookMessage>>(){};
                break;
            }
            case PAYOUT_FAILED: 
            case PAYOUT_SUCCESS: {
                typeToken = new TypeReference<WebhookEvent<PayoutWebhookMessage>>(){};
            }
        }
        if (typeToken == null) {
            throw new WebhookException("Unknown webhook type");
        }
        return (WebhookEvent)ApiResource.GSON.fromJson((JsonElement)obj, typeToken.getType());
    }

    private boolean validateSignature(byte[] body, byte[] signature, X509Certificate certificate) throws com.basicex.sdk.exception.SignatureException {
        try {
            Signature sign = Signature.getInstance(certificate.getSigAlgName());
            sign.initVerify(certificate.getPublicKey());
            sign.update(body);
            return sign.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new com.basicex.sdk.exception.SignatureException(e.getMessage(), e);
        }
    }

    private X509Certificate getPlatformCertificate(String serialNo) throws BasicexException {
        List<PlatformCertificateObject> certificates = this.platformService.certificates();
        Optional<PlatformCertificateObject> certificate = certificates.stream().filter(x -> x.getSerialNumber().equals(serialNo)).findFirst();
        if (!certificate.isPresent()) {
            throw new com.basicex.sdk.exception.SignatureException("platform certificate does not exist", null, null, null);
        }
        try {
            List<X509Certificate> certificateList = X509CertificateUtils.toX509CertificateList(certificate.get().getCertificate());
            if (certificateList == null || certificateList.isEmpty()) {
                throw new com.basicex.sdk.exception.SignatureException("Failed to parse platform certificate", null, null, null);
            }
            return certificateList.get(0);
        }
        catch (CertificateException e) {
            throw new com.basicex.sdk.exception.SignatureException("Failed to parse platform certificate", e);
        }
    }

    private String httpServletRequestToString(HttpServletRequest request) throws IOException {
        ServletInputStream mServletInputStream = request.getInputStream();
        byte[] httpInData = new byte[request.getContentLength()];
        int retVal = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while ((retVal = mServletInputStream.read(httpInData)) != -1) {
            for (int i = 0; i < retVal; ++i) {
                stringBuilder.append((char)httpInData[i]);
            }
        }
        return stringBuilder.toString();
    }
}

