package com.googlecode.mjorm.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks a property as being an identifier.  There may
 * only be one identifier per {@link Entity}. This
 * annotation must be used along with {@link Property}.
 */
@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Id {

	/**
	 * Enables or disables the auto generation
	 * of this field's value.
	 * @return true or false
	 */
	boolean autoGenerated() default true;

}
