package com.googlecode.mjorm.convert.converters;

import java.util.List;

import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.ObjectDescriptor;
import com.googlecode.mjorm.ObjectDescriptorRegistry;
import com.googlecode.mjorm.ObjectIdValueGenerator;
import com.googlecode.mjorm.PropertyDescriptor;
import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBObject;

public class PojoToMongoTypeConverter
	implements TypeConverter<Object, BasicDBObject> {

	private ObjectDescriptorRegistry registry;

	public PojoToMongoTypeConverter(ObjectDescriptorRegistry registry) {
		this.registry = registry;
	}

	public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
		return registry.hasDescriptor(sourceClass)
			&& BasicDBObject.class.equals(targetClass);
	}

	public BasicDBObject convert(
		Object source, JavaType targetType, ConversionContext context, TypeConversionHints hints)
		throws ConversionException {

		// get source class
		Class<?> sourceClass = source.getClass();

		// get the descriptors
		List<ObjectDescriptor> descriptors = registry.getDescriptorsForType(sourceClass);
		if (descriptors.isEmpty()) {
			throw new MjormException("Unable to find ObjectDescriptor for "+sourceClass.getClass());
		}

		// create the return object
		BasicDBObject ret = new BasicDBObject();

		// loop through each descriptor
		for (ObjectDescriptor descriptor : descriptors) {
	
			// loop through each property
			for (PropertyDescriptor prop : descriptor.getProperties()) {
	
				try {
					// get it
					Object value = prop.get(source);
	
					// auto generate value
					if (prop.isAutoGenerated() && value==null) {
						value = prop.getValueGenerator()!=null
							? prop.getValueGenerator().generate()
							: ObjectIdValueGenerator.INSTANCE.generate();
						prop.set(source, context.convert(value, prop.getType()));
					}

					// the field name
					String fieldName = prop.isIdentifier() ? "_id" : prop.getFieldName();

					// convert it
					if (value!=null) {

						// get storage type
						JavaType storageType = prop.getStorageType();
						if (storageType==null && value!=null) {
							storageType = context.getStorageType(value.getClass());
						}

						// convert
						value = context.convert(value, storageType);
					}

					// set on DBObject
					ret.put(fieldName, value);

				} catch (Exception e) {
					throw new MjormException(
						"Error mapping property "+prop.getName()
						+" of class "+descriptor.getType(), e);
				}
	
			}
		}

		// return it
		return ret;
	}

}
