/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm;

import com.googlecode.mjorm.MapReduce;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MapReduceConfiguration {
    private String mapFunction;
    private String reduceFunction;
    private String finalizeFunction;

    public MapReduceConfiguration(Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        this.mapFunction = this.getValue(xpath, "/mapreduce/map/text()", doc);
        this.reduceFunction = this.getValue(xpath, "/mapreduce/reduce/text()", doc);
        this.finalizeFunction = this.getValue(xpath, "/mapreduce/finalize/text()", doc);
    }

    public MapReduce createMapReduce() {
        return new MapReduce(this.mapFunction, this.reduceFunction, this.finalizeFunction);
    }

    private String getValue(XPath xpath, String expression, Document doc) throws XPathExpressionException {
        String val = xpath.evaluate(expression, doc);
        if (val != null) {
            val = val.replace("^[\\s\\r\\n]", "");
            val = val.replace("[\\s\\r\\n]$", "");
        }
        return val != null && val.trim().length() > 0 ? val : null;
    }

    public static MapReduceConfiguration create(InputStream ips) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return new MapReduceConfiguration(builder.parse(ips));
    }

    public static MapReduceConfiguration create(File file) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        return MapReduceConfiguration.create(new FileInputStream(file));
    }

    public String getMapFunction() {
        return this.mapFunction;
    }

    public String getReduceFunction() {
        return this.reduceFunction;
    }

    public String getFinalizeFunction() {
        return this.finalizeFunction;
    }
}

