/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.annotations;

import com.googlecode.mjorm.DiscriminatorType;
import com.googlecode.mjorm.MappingUtil;
import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.ObjectDescriptor;
import com.googlecode.mjorm.ObjectIdValueGenerator;
import com.googlecode.mjorm.PropertyDescriptor;
import com.googlecode.mjorm.ReflectionUtil;
import com.googlecode.mjorm.ValueGenerator;
import com.googlecode.mjorm.annotations.Entity;
import com.googlecode.mjorm.annotations.Id;
import com.googlecode.mjorm.annotations.Property;
import com.googlecode.mjorm.annotations.SubClass;
import com.googlecode.mjorm.annotations.TypeConversionHint;
import com.googlecode.mjorm.convert.JavaType;
import java.beans.BeanInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsObjectDescriptorParser {
    public List<ObjectDescriptor> parseClasses(Class<?> ... classes) {
        ArrayList<ObjectDescriptor> ret = new ArrayList<ObjectDescriptor>();
        for (Class<?> clazz : classes) {
            ret.add(this.parseClass(clazz, ret));
        }
        return ret;
    }

    public List<ObjectDescriptor> parseClasses(Collection<Class<?>> classes) {
        return this.parseClasses(classes.toArray(new Class[0]));
    }

    private ObjectDescriptor parseClass(Class<?> clazz, List<ObjectDescriptor> descriptors) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity == null) {
            throw new MjormException(clazz.getName() + " does not have an " + Entity.class.getName() + " annotation");
        }
        String discriminatorName = entity.discriminatorName();
        DiscriminatorType discriminatorType = entity.discriminatorType();
        SubClass[] subClasses = entity.subClasses();
        ObjectDescriptor desc = new ObjectDescriptor();
        desc.setType(clazz);
        desc.setDiscriminatorName(discriminatorName);
        desc.setDiscriminatorType(discriminatorType.toString());
        BeanInfo info = ReflectionUtil.getBeanInfo(clazz);
        HashMap<Method, java.beans.PropertyDescriptor> methodMap = new HashMap<Method, java.beans.PropertyDescriptor>();
        for (java.beans.PropertyDescriptor pd : info.getPropertyDescriptors()) {
            methodMap.put(pd.getReadMethod(), pd);
            methodMap.put(pd.getWriteMethod(), pd);
        }
        for (Method method : clazz.getMethods()) {
            Property property = method.getAnnotation(Property.class);
            Id id = method.getAnnotation(Id.class);
            if (property == null) continue;
            java.beans.PropertyDescriptor pd = (java.beans.PropertyDescriptor)methodMap.get(method);
            if (pd == null) {
                throw new MjormException(method.getName() + " is not not a valid bean method.");
            }
            String propField = !property.field().equals("") ? property.field() : pd.getName();
            Type propType = !property.type().equals(Void.TYPE) ? property.type() : pd.getReadMethod().getGenericReturnType();
            Class<Object> storageType = !property.storageType().equals(Void.TYPE) ? property.storageType() : null;
            Class<?> valueGeneratorClass = !property.valueGeneratorClass().equals(Void.TYPE) ? property.valueGeneratorClass() : null;
            Type[] genericParameterTypes = property.genericParameterTypes().length > 0 ? property.genericParameterTypes() : new Type[]{};
            boolean propIsIdentifier = id != null;
            boolean propIsAutoGen = id != null && id.autoGenerated();
            HashMap<String, Object> hints = new HashMap<String, Object>();
            if (property.typeConversionHints() != null) {
                for (TypeConversionHint hint : property.typeConversionHints()) {
                    hints.put(hint.name(), hint.stringValue());
                }
            }
            PropertyDescriptor prop = new PropertyDescriptor();
            prop.setName(pd.getName());
            prop.setFieldName(propField);
            prop.setGetter(pd.getReadMethod());
            prop.setSetter(pd.getWriteMethod());
            prop.setIdentifier(propIsIdentifier);
            prop.setType(JavaType.fromType(propType));
            prop.setAutoGenerated(propIsAutoGen);
            prop.setConversionHints(hints);
            prop.setGenericParameterTypes(genericParameterTypes);
            if (propIsAutoGen) {
                ValueGenerator<ObjectId> valueGenerator = null;
                if (valueGeneratorClass == null) {
                    valueGenerator = ObjectIdValueGenerator.INSTANCE;
                    storageType = ObjectId.class;
                } else {
                    try {
                        valueGenerator = (ValueGenerator)ValueGenerator.class.cast(valueGeneratorClass.newInstance());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to create ValueGenerator for " + valueGeneratorClass.getName(), e);
                    }
                }
                prop.setValueGenerator(valueGenerator);
            }
            if (storageType != null) {
                prop.setStorageType(JavaType.fromType(storageType));
            }
            desc.addPropertyDescriptor(prop);
        }
        for (SubClass subClassAnot : subClasses) {
            Object discriminatorValue = MappingUtil.parseDiscriminator(subClassAnot.discriminiatorValue(), discriminatorType);
            ObjectDescriptor subClass = this.parseClass(subClassAnot.entityClass(), descriptors);
            desc.addSubClassObjectDescriptor(discriminatorValue, subClass);
            descriptors.add(subClass);
        }
        return desc;
    }
}

