/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBObject;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToMongoTypeConverter
implements TypeConverter<Map<String, Object>, BasicDBObject> {
    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return !BasicDBObject.class.isAssignableFrom(sourceClass) && Map.class.isAssignableFrom(sourceClass) && BasicDBObject.class.equals(targetClass);
    }

    @Override
    public BasicDBObject convert(Map<String, Object> source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        BasicDBObject ret = new BasicDBObject();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value != null) {
                JavaType storageType = context.getStorageType(value.getClass());
                value = context.convert(entry.getValue(), storageType);
            }
            ret.put(entry.getKey(), value);
        }
        return ret;
    }
}

