/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBList;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoToArrayTypeConverter
implements TypeConverter<BasicDBList, Object[]> {
    @Override
    public boolean canConvert(Class<?> dbClass, Class<?> targetClass) {
        return BasicDBList.class.equals(dbClass) && targetClass.isArray();
    }

    @Override
    public Object[] convert(BasicDBList source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        JavaType componentType = null;
        Type[] types = (Type[])hints.get("genericTypeParameters");
        if (types != null && types.length > 0) {
            componentType = JavaType.fromType(types[0]);
        }
        if (componentType == null) {
            componentType = targetType.getComponentJavaType();
        }
        if (componentType == null) {
            throw new ConversionException("Unable to determine componentType of " + targetType);
        }
        Object ret = Array.newInstance(componentType.asClass(), source.size());
        for (int i = 0; i < source.size(); ++i) {
            Object value = source.get(i);
            if (value != null) {
                value = context.convert(value, componentType);
            }
            Array.set(ret, i, value);
        }
        return (Object[])Object[].class.cast(ret);
    }
}

