/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.DBObjectUtil;
import com.googlecode.mjorm.MjormException;
import com.googlecode.mjorm.ObjectDescriptor;
import com.googlecode.mjorm.ObjectDescriptorRegistry;
import com.googlecode.mjorm.PropertyDescriptor;
import com.googlecode.mjorm.ReflectionUtil;
import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoToPojoTypeConverter
implements TypeConverter<BasicDBObject, Object> {
    private ObjectDescriptorRegistry registry;

    public MongoToPojoTypeConverter(ObjectDescriptorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return this.registry.hasDescriptor(targetClass) && BasicDBObject.class.equals(sourceClass);
    }

    @Override
    public Object convert(BasicDBObject source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        Object ret;
        Class<?> targetClass = targetType.asClass();
        LinkedList<ObjectDescriptor> descriptors = this.registry.getDescriptorsForType(targetClass);
        if (descriptors.isEmpty()) {
            throw new MjormException("Unable to find ObjectDescriptor for " + targetClass);
        }
        ObjectDescriptor descriptor = descriptors.get(descriptors.size() - 1);
        String discriminatorName = descriptor.getDiscriminatorName();
        Object discriminator = null;
        if (discriminatorName != null && discriminatorName.trim().length() > 0) {
            discriminator = DBObjectUtil.getNestedProperty((DBObject)source, discriminatorName);
        }
        if (discriminator != null) {
            ObjectDescriptor subClass = descriptor.getSubClassObjectDescriptor(discriminator);
            if (subClass == null && Modifier.isAbstract(descriptor.getType().getModifiers())) {
                throw new MjormException("Sublcass for discriminiator value " + discriminator + " was not found on abstract ObjectDescriptor for " + descriptor.getType().getName());
            }
            if (subClass != null) {
                descriptor = subClass;
                descriptors.addFirst(subClass);
            }
        }
        try {
            ret = ReflectionUtil.instantiate(descriptor.getType(), new Object[0]);
        }
        catch (Exception e) {
            throw new MjormException("Error creating class: " + targetClass, e);
        }
        for (ObjectDescriptor desc : descriptors) {
            for (PropertyDescriptor prop : desc.getProperties()) {
                try {
                    String fieldName = prop.isIdentifier() ? "_id" : prop.getFieldName();
                    Object value = source.get(fieldName);
                    if (value != null) {
                        Type[] genericParameterTypes;
                        TypeConversionHints nextHints = new TypeConversionHints();
                        if (prop.getConversionHints() != null && !prop.getConversionHints().isEmpty()) {
                            for (Map.Entry<String, Object> entry : prop.getConversionHints().entrySet()) {
                                nextHints.set(entry.getKey(), entry.getValue());
                            }
                        }
                        if ((genericParameterTypes = prop.getGenericParameterTypes()) != null && genericParameterTypes.length > 0) {
                            nextHints.set("genericTypeParameters", genericParameterTypes);
                        }
                        value = context.convert(value, prop.getType(), nextHints);
                    }
                    prop.set(ret, value);
                }
                catch (Exception e) {
                    throw new MjormException("Error mapping property " + prop.getName() + " of class " + descriptor.getType(), e);
                }
            }
        }
        return ret;
    }
}

