/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.convert.converters;

import com.googlecode.mjorm.convert.ConversionContext;
import com.googlecode.mjorm.convert.ConversionException;
import com.googlecode.mjorm.convert.JavaType;
import com.googlecode.mjorm.convert.TypeConversionHints;
import com.googlecode.mjorm.convert.TypeConverter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberTypeConverter
implements TypeConverter<Number, Number> {
    @Override
    public boolean canConvert(Class<?> sourceClass, Class<?> targetClass) {
        return !(!Number.class.isAssignableFrom(sourceClass) && !Byte.TYPE.isAssignableFrom(targetClass) && !Short.TYPE.isAssignableFrom(targetClass) && !Integer.TYPE.isAssignableFrom(targetClass) && !Long.TYPE.isAssignableFrom(targetClass) && !Float.TYPE.isAssignableFrom(targetClass) && !Double.TYPE.isAssignableFrom(targetClass) || !Number.class.isAssignableFrom(targetClass) && !Byte.TYPE.isAssignableFrom(targetClass) && !Short.TYPE.isAssignableFrom(targetClass) && !Integer.TYPE.isAssignableFrom(targetClass) && !Long.TYPE.isAssignableFrom(targetClass) && !Float.TYPE.isAssignableFrom(targetClass) && !Double.TYPE.isAssignableFrom(targetClass));
    }

    @Override
    public Number convert(Number source, JavaType targetType, ConversionContext context, TypeConversionHints hints) throws ConversionException {
        if (targetType.is((Type)((Object)Byte.class)) || targetType.is(Byte.TYPE)) {
            return source.byteValue();
        }
        if (targetType.is((Type)((Object)Short.class)) || targetType.is(Short.TYPE)) {
            return source.shortValue();
        }
        if (targetType.is((Type)((Object)Integer.class)) || targetType.is(Integer.TYPE)) {
            return source.intValue();
        }
        if (targetType.is((Type)((Object)Long.class)) || targetType.is(Long.TYPE)) {
            return source.longValue();
        }
        if (targetType.is((Type)((Object)Float.class)) || targetType.is(Float.TYPE)) {
            return Float.valueOf(source.floatValue());
        }
        if (targetType.is((Type)((Object)Double.class)) || targetType.is(Double.TYPE)) {
            return source.doubleValue();
        }
        if (targetType.is((Type)((Object)BigDecimal.class))) {
            return BigDecimal.valueOf(source.floatValue());
        }
        if (targetType.is((Type)((Object)BigInteger.class))) {
            return BigInteger.valueOf(source.longValue());
        }
        throw new ConversionException("Unable to convert source Number to " + targetType);
    }
}

